/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.completion;

import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.completion.CompletionEventListener;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.function.Consumer;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.StreamResetException;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompletionEventSourceListener<T>
extends EventSourceListener {
    private static final Logger LOG = LoggerFactory.getLogger(CompletionEventSourceListener.class);
    private final CompletionEventListener<T> listeners;
    private final StringBuilder messageBuilder = new StringBuilder();
    private final boolean retryOnReadTimeout;
    private final Consumer<String> onRetry;

    public CompletionEventSourceListener(CompletionEventListener<T> listeners) {
        this(listeners, false, null);
    }

    public CompletionEventSourceListener(CompletionEventListener<T> listeners, boolean retryOnReadTimeout, Consumer<String> onRetry) {
        this.listeners = listeners;
        this.retryOnReadTimeout = retryOnReadTimeout;
        this.onRetry = onRetry;
    }

    protected abstract T getMessage(String var1) throws JsonProcessingException;

    protected abstract ErrorDetails getErrorDetails(String var1) throws JsonProcessingException;

    public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
        LOG.info("Request opened.");
    }

    public void onClosed(@NotNull EventSource eventSource) {
        LOG.info("Request closed.");
        this.listeners.onComplete(this.messageBuilder);
    }

    public void onEvent(@NotNull EventSource eventSource, String id, String type, @NotNull String data) {
        try {
            if ("[DONE]".equals(data)) {
                return;
            }
            T message = this.getMessage(data);
            if (message != null) {
                this.messageBuilder.append(message);
                this.listeners.onMessage(message, eventSource);
                this.listeners.onMessage(message, data, eventSource);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to deserialize payload.", e);
        }
    }

    public void onFailure(@NotNull EventSource eventSource, Throwable throwable, Response response) {
        block9: {
            if (throwable instanceof StreamResetException || throwable instanceof SocketException && "Socket closed".equals(throwable.getMessage())) {
                LOG.info("Stream was cancelled");
                this.listeners.onCancelled(this.messageBuilder);
                return;
            }
            if (throwable instanceof SocketTimeoutException) {
                if (this.retryOnReadTimeout) {
                    LOG.info("Retrying request.");
                    this.onRetry.accept(this.messageBuilder.toString());
                    return;
                }
                this.listeners.onError(new ErrorDetails("Request timed out. This may be due to the server being overloaded."), throwable);
                return;
            }
            try {
                if (response == null) {
                    this.listeners.onError(new ErrorDetails(throwable.getMessage()), throwable);
                    return;
                }
                ResponseBody body = response.body();
                if (body == null) break block9;
                String jsonBody = body.string();
                try {
                    ErrorDetails errorDetails = this.getErrorDetails(jsonBody);
                    if (errorDetails == null || errorDetails.getMessage() == null || errorDetails.getMessage().isEmpty()) {
                        this.listeners.onError(this.toUnknownErrorResponse(response, jsonBody), new RuntimeException());
                        break block9;
                    }
                    this.listeners.onError(errorDetails, new RuntimeException());
                }
                catch (JsonProcessingException e) {
                    LOG.error("Could not serialize error response", throwable);
                    this.listeners.onError(this.toUnknownErrorResponse(response, jsonBody), e);
                }
            }
            catch (IOException ex) {
                this.listeners.onError(new ErrorDetails(ex.getMessage()), ex);
            }
        }
    }

    private ErrorDetails toUnknownErrorResponse(Response response, String jsonBody) {
        return new ErrorDetails(String.format("Unknown API response. Code: %s, Body: %s", response.code(), jsonBody));
    }
}

