/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.google.completion;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Base64;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GoogleContentPart {
    private String text;
    private Blob inlineData;
    private Boolean thought;

    public GoogleContentPart() {
    }

    public GoogleContentPart(String text) {
        this(text, null, null);
    }

    public GoogleContentPart(String text, Blob inlineData) {
        this(text, inlineData, null);
    }

    public GoogleContentPart(String text, Blob inlineData, Boolean thought) {
        this.text = text;
        this.inlineData = inlineData;
        this.thought = thought;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Blob getInlineData() {
        return this.inlineData;
    }

    public void setInlineData(Blob inlineData) {
        this.inlineData = inlineData;
    }

    public Boolean getThought() {
        return this.thought;
    }

    public void setThought(Boolean thought) {
        this.thought = thought;
    }

    public static class Blob {
        public static final Base64.Encoder ENCODER = Base64.getEncoder();
        private String mimeType;
        private String data;

        public Blob() {
        }

        public Blob(String mimeType, byte[] data) {
            this.mimeType = mimeType;
            this.data = ENCODER.encodeToString(data);
        }

        public Blob(String mimeType, String base64EncodedData) {
            this.mimeType = mimeType;
            this.data = base64EncodedData;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

