/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.ollama;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.DeserializationUtil;
import ee.carlrobert.llm.client.InterceptorUtil;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaChatCompletionRequest;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaCompletionRequest;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaEmbeddingRequest;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaPullRequest;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaChatCompletionResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaCompletionResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaEmbeddingResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaModelInfoResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaPullResponse;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaTagsResponse;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.client.openai.completion.OpenAIChatCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.request.OpenAIChatCompletionRequest;
import ee.carlrobert.llm.client.openai.completion.response.OpenAIChatCompletionResponse;
import ee.carlrobert.llm.completion.CompletionEventListener;
import ee.carlrobert.llm.completion.CompletionEventSourceListener;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class OllamaClient {
    private static final String BASE_URL = PropertiesLoader.getValue("ollama.baseUrl");
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private final OkHttpClient httpClient;
    private final String host;
    private final Integer port;
    private final String apiKey;

    protected OllamaClient(Builder builder, OkHttpClient.Builder httpClientBuilder) {
        this.httpClient = httpClientBuilder.addInterceptor(InterceptorUtil.REWRITE_X_NDJSON_CONTENT_INTERCEPTOR).build();
        this.host = builder.host;
        this.port = builder.port;
        this.apiKey = builder.apiKey;
    }

    private static RequestBody createRequestBody(Object request) throws JsonProcessingException {
        return RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString(request), (MediaType)APPLICATION_JSON);
    }

    public EventSource getCompletionAsync(OllamaCompletionRequest request, CompletionEventListener<String> eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildPostRequest(request, "/api/generate", true), this.getCompletionEventSourceListener(eventListener));
    }

    public EventSource getChatCompletionAsync(OpenAIChatCompletionRequest request, CompletionEventListener<String> eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildPostRequest(request, "/v1/chat/completions", true), (EventSourceListener)new OpenAIChatCompletionEventSourceListener(eventListener));
    }

    public EventSource getChatCompletionAsync(OllamaChatCompletionRequest request, CompletionEventListener<String> eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildPostRequest(request, "/api/chat", true), this.getChatCompletionEventSourceListener(eventListener));
    }

    public OllamaCompletionResponse getCompletion(OllamaCompletionRequest request) {
        OllamaCompletionResponse ollamaCompletionResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(request, "/api/generate")).execute();
            try {
                ollamaCompletionResponse = DeserializationUtil.mapResponse(response, OllamaCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama completion for the given request:\n" + request, e);
                }
            }
            response.close();
        }
        return ollamaCompletionResponse;
    }

    public OllamaChatCompletionResponse getChatCompletion(OllamaChatCompletionRequest request) {
        OllamaChatCompletionResponse ollamaChatCompletionResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(request, "/api/chat")).execute();
            try {
                ollamaChatCompletionResponse = DeserializationUtil.mapResponse(response, OllamaChatCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama chat completion for the given request:\n" + request, e);
                }
            }
            response.close();
        }
        return ollamaChatCompletionResponse;
    }

    public OpenAIChatCompletionResponse getChatCompletion(OpenAIChatCompletionRequest request) {
        OpenAIChatCompletionResponse openAIChatCompletionResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(request, "/v1/chat/completions", false)).execute();
            try {
                openAIChatCompletionResponse = DeserializationUtil.mapResponse(response, OpenAIChatCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return openAIChatCompletionResponse;
    }

    public OllamaEmbeddingResponse getEmbedding(OllamaEmbeddingRequest request) {
        OllamaEmbeddingResponse ollamaEmbeddingResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(request, "/api/embeddings")).execute();
            try {
                ollamaEmbeddingResponse = DeserializationUtil.mapResponse(response, OllamaEmbeddingResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama embedding for the given request:\n" + request, e);
                }
            }
            response.close();
        }
        return ollamaEmbeddingResponse;
    }

    public OllamaPullResponse pullModel(OllamaPullRequest request) {
        OllamaPullResponse ollamaPullResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(request, "/api/pull")).execute();
            try {
                ollamaPullResponse = DeserializationUtil.mapResponse(response, OllamaPullResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not pull ollama model for the given request:\n" + request, e);
                }
            }
            response.close();
        }
        return ollamaPullResponse;
    }

    public EventSource pullModelAsync(OllamaPullRequest request, CompletionEventListener<OllamaPullResponse> eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildPostRequest(request, "/api/pull", true), this.getPullModelEventSourceListener(eventListener));
    }

    public boolean deleteModel(String model) {
        boolean bl;
        block8: {
            Response response = this.httpClient.newCall(this.defaultRequest("/api/delete").delete(OllamaClient.createRequestBody(Map.of("name", model))).build()).execute();
            try {
                bl = response.isSuccessful();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not delete ollama model for the given model name:\n" + model, e);
                }
            }
            response.close();
        }
        return bl;
    }

    public OllamaTagsResponse getModelTags() {
        OllamaTagsResponse ollamaTagsResponse;
        block8: {
            Response response = this.httpClient.newCall(this.defaultRequest("/api/tags").get().build()).execute();
            try {
                ollamaTagsResponse = DeserializationUtil.mapResponse(response, OllamaTagsResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama model tags:\n", e);
                }
            }
            response.close();
        }
        return ollamaTagsResponse;
    }

    public OllamaModelInfoResponse getModelInfo(String model) {
        OllamaModelInfoResponse ollamaModelInfoResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildPostRequest(Map.of("name", model), "/api/show")).execute();
            try {
                ollamaModelInfoResponse = DeserializationUtil.mapResponse(response, OllamaModelInfoResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get ollama model info for the given model name:\n" + model, e);
                }
            }
            response.close();
        }
        return ollamaModelInfoResponse;
    }

    private Request buildPostRequest(Object request, String path) {
        return this.buildPostRequest(request, path, false);
    }

    private Request buildPostRequest(Object request, String path, boolean stream) {
        try {
            return this.defaultRequest(path, stream).post(OllamaClient.createRequestBody(request)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Request.Builder defaultRequest(String path) {
        return this.defaultRequest(path, false);
    }

    private Request.Builder defaultRequest(String path, boolean stream) {
        String baseHost = this.port == null ? BASE_URL : String.format("http://localhost:%d", this.port);
        Request.Builder builder = new Request.Builder().url((this.host == null ? baseHost : this.host) + path).header("Cache-Control", "no-cache").header("Content-Type", "application/json").header("Accept", stream ? "text/event-stream" : "text/json");
        if (this.apiKey != null) {
            builder.header("Authorization", "Bearer " + this.apiKey);
        }
        return builder;
    }

    private CompletionEventSourceListener<String> getChatCompletionEventSourceListener(CompletionEventListener<String> eventListener) {
        return new CompletionEventSourceListener<String>(eventListener){

            @Override
            protected String getMessage(String data) {
                try {
                    return ((OllamaChatCompletionResponse)DeserializationUtil.OBJECT_MAPPER.readValue(data, OllamaChatCompletionResponse.class)).getMessage().getContent();
                }
                catch (JacksonException e) {
                    return "";
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    private CompletionEventSourceListener<String> getCompletionEventSourceListener(CompletionEventListener<String> eventListener) {
        return new CompletionEventSourceListener<String>(eventListener){

            @Override
            protected String getMessage(String data) {
                try {
                    return ((OllamaCompletionResponse)DeserializationUtil.OBJECT_MAPPER.readValue(data, OllamaCompletionResponse.class)).getResponse();
                }
                catch (JacksonException e) {
                    return "";
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    private CompletionEventSourceListener<OllamaPullResponse> getPullModelEventSourceListener(CompletionEventListener<OllamaPullResponse> eventListener) {
        return new CompletionEventSourceListener<OllamaPullResponse>(eventListener){

            @Override
            protected OllamaPullResponse getMessage(String data) {
                try {
                    return (OllamaPullResponse)DeserializationUtil.OBJECT_MAPPER.readValue(data, OllamaPullResponse.class);
                }
                catch (JacksonException e) {
                    return null;
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String apiKey;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OllamaClient build(OkHttpClient.Builder builder) {
            return new OllamaClient(this, builder);
        }

        public OllamaClient build() {
            return this.build(new OkHttpClient.Builder());
        }
    }
}

