/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.ollama.completion.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaParameters;
import ee.carlrobert.llm.client.ollama.completion.response.OllamaResponseFormat;
import ee.carlrobert.llm.completion.CompletionRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OllamaCompletionRequest
implements CompletionRequest {
    private final String model;
    private final String prompt;
    private final OllamaResponseFormat format;
    private final OllamaParameters options;
    private final String system;
    private final String template;
    private final String context;
    private final Boolean stream;
    private final Boolean raw;
    private final String suffix;

    public OllamaCompletionRequest(Builder builder) {
        this.prompt = builder.prompt;
        this.model = builder.model;
        this.format = builder.format;
        this.options = builder.options;
        this.system = builder.system;
        this.template = builder.template;
        this.context = builder.context;
        this.stream = builder.stream;
        this.raw = builder.raw;
        this.suffix = builder.suffix;
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public OllamaResponseFormat getFormat() {
        return this.format;
    }

    public OllamaParameters getOptions() {
        return this.options;
    }

    public String getSystem() {
        return this.system;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getContext() {
        return this.context;
    }

    public Boolean isStream() {
        return this.stream;
    }

    public Boolean isRaw() {
        return this.raw;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public static class Builder {
        private final String model;
        private final String prompt;
        private OllamaResponseFormat format = null;
        private OllamaParameters options = null;
        private String system = null;
        private String template = null;
        private String context = null;
        private Boolean stream = null;
        private Boolean raw = null;
        private String suffix = null;

        public Builder(String model, String prompt) {
            this.model = model;
            this.prompt = prompt;
        }

        public Builder setFormat(OllamaResponseFormat format) {
            this.format = format;
            return this;
        }

        public Builder setOptions(OllamaParameters options) {
            this.options = options;
            return this;
        }

        public Builder setSystem(String system) {
            this.system = system;
            return this;
        }

        public Builder setTemplate(String template) {
            this.template = template;
            return this;
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        public Builder setStream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder setRaw(boolean raw) {
            this.raw = raw;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public OllamaCompletionRequest build() {
            return new OllamaCompletionRequest(this);
        }
    }
}

