/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.you.completion;

import java.util.Arrays;

public enum YouCompletionMode {
    DEFAULT("default", false),
    AGENT("agent", false),
    CUSTOM("custom", true),
    RESEARCH("research", false);

    private final String code;
    private final boolean supportCustomModel;

    private YouCompletionMode(String code, boolean supportCustomModel) {
        this.code = code;
        this.supportCustomModel = supportCustomModel;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.code.substring(0, 1).toUpperCase() + this.code.substring(1);
    }

    public boolean isSupportCustomModel() {
        return this.supportCustomModel;
    }

    public String toString() {
        return this.code;
    }

    public static YouCompletionMode findByCode(String code) {
        return Arrays.stream(YouCompletionMode.values()).filter(item -> item.getCode().equals(code)).findFirst().orElseThrow();
    }
}

