/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.anthropic.completion;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeName;
import ee.carlrobert.llm.client.anthropic.completion.ClaudeSource;
import java.util.Base64;

@JsonTypeName(value="base64")
public class ClaudeBase64Source
extends ClaudeSource {
    @JsonProperty(value="media_type")
    private String mediaType;
    private byte[] data;

    public ClaudeBase64Source(String mediaType, byte[] data) {
        this.mediaType = mediaType;
        this.data = data;
    }

    public ClaudeBase64Source() {
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @JsonIgnore
    public byte[] getData() {
        return this.data;
    }

    @JsonIgnore
    public void setData(byte[] data) {
        this.data = data;
    }

    @JsonGetter(value="data")
    public String getBase64EncodedData() {
        return Base64.getEncoder().encodeToString(this.data);
    }

    @JsonSetter(value="data")
    public void setBase64EncodedData(String base64Data) {
        this.data = Base64.getDecoder().decode(base64Data);
    }
}

