/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import ee.carlrobert.llm.client.DeserializationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class RequestEntity {
    private final URI uri;
    private final Map<String, Object> body;
    private final Headers headers;
    private final String method;

    public RequestEntity(HttpExchange exchange) throws IOException {
        this.uri = exchange.getRequestURI();
        this.body = this.toMap(IOUtils.toString((InputStream)exchange.getRequestBody(), (Charset)StandardCharsets.UTF_8));
        this.headers = exchange.getRequestHeaders();
        this.method = exchange.getRequestMethod();
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    private Map<String, Object> toMap(String json) throws IOException {
        if (json == null || json.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)DeserializationUtil.OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }
}

