/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.llama;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.DeserializationUtil;
import ee.carlrobert.llm.client.llama.completion.LlamaCompletionRequest;
import ee.carlrobert.llm.client.llama.completion.LlamaCompletionResponse;
import ee.carlrobert.llm.client.llama.completion.LlamaInfillRequest;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.completion.CompletionEventListener;
import ee.carlrobert.llm.completion.CompletionEventSourceListener;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class LlamaClient {
    private static final String BASE_URL = PropertiesLoader.getValue("llama.baseUrl");
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private final OkHttpClient httpClient;
    private final String host;
    private final Integer port;
    private final String apiKey;

    protected LlamaClient(Builder builder, OkHttpClient.Builder httpClientBuilder) {
        this.httpClient = httpClientBuilder.build();
        this.host = builder.host;
        this.port = builder.port;
        this.apiKey = builder.apiKey;
    }

    public EventSource getChatCompletionAsync(LlamaCompletionRequest request, CompletionEventListener<String> eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildCompletionHttpRequest(request), (EventSourceListener)this.getEventSourceListener(eventListener));
    }

    public LlamaCompletionResponse getChatCompletion(LlamaCompletionRequest request) {
        LlamaCompletionResponse llamaCompletionResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildCompletionHttpRequest(request)).execute();
            try {
                llamaCompletionResponse = DeserializationUtil.mapResponse(response, LlamaCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get llama completion for the given request:\n" + String.valueOf(request), e);
                }
            }
            response.close();
        }
        return llamaCompletionResponse;
    }

    public LlamaCompletionResponse getInfill(LlamaInfillRequest request) {
        LlamaCompletionResponse llamaCompletionResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildHttpRequest(request, "/infill")).execute();
            try {
                llamaCompletionResponse = DeserializationUtil.mapResponse(response, LlamaCompletionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get llama completion for the given request:\n" + String.valueOf(request), e);
                }
            }
            response.close();
        }
        return llamaCompletionResponse;
    }

    public EventSource getInfillAsync(LlamaInfillRequest request, CompletionEventListener eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildHttpRequest(request, "/infill"), (EventSourceListener)this.getEventSourceListener(eventListener));
    }

    private Request buildCompletionHttpRequest(LlamaCompletionRequest request) {
        return this.buildHttpRequest(request, "/completion");
    }

    private Request buildHttpRequest(LlamaCompletionRequest request, String path) {
        try {
            String baseHost = this.port == null ? BASE_URL : String.format("http://localhost:%d", this.port);
            Request.Builder builder = new Request.Builder().url((this.host == null ? baseHost : this.host) + path).header("Cache-Control", "no-cache").header("Content-Type", "application/json").header("Accept", request.isStream() != false ? "text/event-stream" : "text/json").post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON));
            if (this.apiKey != null) {
                builder.header("Authorization", "Bearer " + this.apiKey);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletionEventSourceListener getEventSourceListener(CompletionEventListener eventListener) {
        return new CompletionEventSourceListener(eventListener){

            protected String getMessage(String data) {
                try {
                    LlamaCompletionResponse response = (LlamaCompletionResponse)DeserializationUtil.OBJECT_MAPPER.readValue(data, LlamaCompletionResponse.class);
                    return response.getContent();
                }
                catch (JacksonException jacksonException) {
                    return "";
                }
            }

            @Override
            protected ErrorDetails getErrorDetails(String error) {
                return new ErrorDetails(error);
            }
        };
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String apiKey;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public LlamaClient build(OkHttpClient.Builder builder) {
            return new LlamaClient(this, builder);
        }

        public LlamaClient build() {
            return this.build(new OkHttpClient.Builder());
        }
    }
}

