/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.mixin;

import ee.carlrobert.llm.client.http.LocalCallbackServer;
import ee.carlrobert.llm.client.http.Service;
import ee.carlrobert.llm.client.http.exchange.BasicHttpExchange;
import ee.carlrobert.llm.client.http.exchange.Exchange;
import ee.carlrobert.llm.client.http.exchange.NdJsonStreamHttpExchange;
import ee.carlrobert.llm.client.http.exchange.StreamHttpExchange;
import ee.carlrobert.llm.client.http.expectation.BasicExpectation;
import ee.carlrobert.llm.client.http.expectation.Expectation;
import ee.carlrobert.llm.client.http.expectation.NdJsonStreamExpectation;
import ee.carlrobert.llm.client.http.expectation.StreamExpectation;
import ee.carlrobert.llm.client.mixin.ExternalService;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public interface ExternalServiceTestMixin {
    public static void init() {
        Private.externalServiceServerMap = Arrays.stream(ExternalService.values()).collect(Collectors.toMap(service -> service, service -> {
            LocalCallbackServer server = new LocalCallbackServer((Service)service);
            System.setProperty(service.getUrlProperty(), "http://localhost:" + server.getPort());
            return server;
        }));
    }

    public static void clearAll() {
        Private.externalServiceServerMap.values().forEach(LocalCallbackServer::clear);
    }

    default public void expectCodeGPT(Exchange exchange) {
        this.addExpectation(ExternalService.CODEGPT, exchange);
    }

    default public void expectOpenAI(Exchange exchange) {
        this.addExpectation(ExternalService.OPENAI, exchange);
    }

    default public void expectAnthropic(Exchange exchange) {
        this.addExpectation(ExternalService.ANTHROPIC, exchange);
    }

    default public void expectAzure(Exchange exchange) {
        this.addExpectation(ExternalService.AZURE, exchange);
    }

    default public void expectYou(Exchange exchange) {
        this.addExpectation(ExternalService.YOU, exchange);
    }

    default public void expectLlama(Exchange exchange) {
        this.addExpectation(ExternalService.LLAMA, exchange);
    }

    default public void expectOllama(Exchange exchange) {
        this.addExpectation(ExternalService.OLLAMA, exchange);
    }

    default public void expectGoogle(Exchange exchange) {
        this.addExpectation(ExternalService.GOOGLE, exchange);
    }

    private void addExpectation(ExternalService externalService, Exchange exchange) {
        Expectation expectation = exchange instanceof StreamHttpExchange ? new StreamExpectation(externalService, (StreamHttpExchange)exchange) : (exchange instanceof NdJsonStreamHttpExchange ? new NdJsonStreamExpectation(externalService, (NdJsonStreamHttpExchange)exchange) : new BasicExpectation(externalService, (BasicHttpExchange)exchange));
        Private.externalServiceServerMap.get(externalService).addExpectation(expectation);
    }

    public static class Private {
        static Map<ExternalService, LocalCallbackServer> externalServiceServerMap;
    }
}

