/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.ollama.completion.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import ee.carlrobert.llm.client.ollama.completion.request.OllamaParameters;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OllamaEmbeddingRequest {
    private final String model;
    private final String prompt;
    private final OllamaParameters options;

    public OllamaEmbeddingRequest(Builder builder) {
        this.prompt = builder.prompt;
        this.model = builder.model;
        this.options = builder.options;
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public OllamaParameters getOptions() {
        return this.options;
    }

    public static class Builder {
        private final String model;
        private final String prompt;
        private OllamaParameters options = null;

        public Builder(String model, String prompt) {
            this.model = model;
            this.prompt = prompt;
        }

        public Builder setOptions(OllamaParameters options) {
            this.options = options;
            return this;
        }

        public OllamaEmbeddingRequest build() {
            return new OllamaEmbeddingRequest(this);
        }
    }
}

