/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.DeserializationUtil;
import ee.carlrobert.llm.client.codegpt.response.CodeGPTException;
import ee.carlrobert.llm.client.openai.completion.ApiResponseError;
import ee.carlrobert.llm.client.openai.completion.OpenAIChatCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.OpenAITextCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.request.OpenAIChatCompletionRequest;
import ee.carlrobert.llm.client.openai.completion.request.OpenAITextCompletionRequest;
import ee.carlrobert.llm.client.openai.completion.response.OpenAIChatCompletionResponse;
import ee.carlrobert.llm.client.openai.embeddings.EmbeddingData;
import ee.carlrobert.llm.client.openai.embeddings.EmbeddingRequest;
import ee.carlrobert.llm.client.openai.embeddings.EmbeddingResponse;
import ee.carlrobert.llm.client.openai.imagegen.request.OpenAIImageGenerationRequest;
import ee.carlrobert.llm.client.openai.imagegen.response.OpenAiImageGenerationResponse;
import ee.carlrobert.llm.completion.CompletionEventListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class OpenAIClient {
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private final OkHttpClient httpClient;
    private final String apiKey;
    private final String organization;
    private final String host;
    private final String pluginVersion;

    private OpenAIClient(Builder builder, OkHttpClient.Builder httpClientBuilder) {
        this.httpClient = httpClientBuilder.build();
        this.apiKey = builder.apiKey;
        this.organization = builder.organization;
        this.host = builder.host;
        this.pluginVersion = builder.pluginVersion;
    }

    public EventSource getCompletionAsync(OpenAITextCompletionRequest request, CompletionEventListener<String> eventListener) {
        return this.getCompletionAsync(request, new OpenAITextCompletionEventSourceListener((CompletionEventListener)eventListener));
    }

    public EventSource getCompletionAsync(OpenAITextCompletionRequest request, OpenAITextCompletionEventSourceListener eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildTextCompletionRequest(request), (EventSourceListener)eventListener);
    }

    public EventSource getChatCompletionAsync(OpenAIChatCompletionRequest request, CompletionEventListener<String> eventListener) {
        return this.getChatCompletionAsync(request, new OpenAIChatCompletionEventSourceListener(eventListener));
    }

    public EventSource getChatCompletionAsync(OpenAIChatCompletionRequest request, OpenAIChatCompletionEventSourceListener eventListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(this.buildChatCompletionRequest(request), (EventSourceListener)eventListener);
    }

    public OpenAIChatCompletionResponse getChatCompletion(OpenAIChatCompletionRequest request) {
        OpenAIChatCompletionResponse openAIChatCompletionResponse;
        block10: {
            Response response = this.httpClient.newCall(this.buildChatCompletionRequest(request)).execute();
            try {
                if (!response.isSuccessful()) {
                    ResponseBody body = response.body();
                    if (body == null) {
                        throw new RuntimeException("Unable to get response body");
                    }
                    ApiResponseError error = (ApiResponseError)DeserializationUtil.OBJECT_MAPPER.readValue(body.string(), ApiResponseError.class);
                    CodeGPTException ex = new CodeGPTException();
                    ex.setDetail(error.getError().getMessage());
                    ex.setStatus(response.code());
                    throw ex;
                }
                openAIChatCompletionResponse = DeserializationUtil.mapResponse(response, OpenAIChatCompletionResponse.class);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return openAIChatCompletionResponse;
    }

    public OpenAiImageGenerationResponse getImage(OpenAIImageGenerationRequest request) {
        OpenAiImageGenerationResponse openAiImageGenerationResponse;
        block8: {
            Response response = this.httpClient.newBuilder().readTimeout(60L, TimeUnit.SECONDS).callTimeout(60L, TimeUnit.SECONDS).build().newCall(this.buildImageRequest(request)).execute();
            try {
                openAiImageGenerationResponse = DeserializationUtil.mapResponse(response, OpenAiImageGenerationResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return openAiImageGenerationResponse;
    }

    public double[] getEmbedding(String input) {
        List<double[]> embeddings = this.getEmbeddings(new EmbeddingRequest("text-embedding-3-large", List.of(input)));
        return embeddings.isEmpty() ? null : embeddings.get(0);
    }

    public List<double[]> getEmbeddings(EmbeddingRequest request) {
        List<double[]> list;
        block8: {
            Response response = this.httpClient.newCall(this.buildEmbeddingsRequest(this.host + "/v1/embeddings", request)).execute();
            try {
                list = Optional.ofNullable(DeserializationUtil.mapResponse(response, EmbeddingResponse.class)).map(EmbeddingResponse::getData).stream().flatMap(Collection::stream).filter(Objects::nonNull).map(EmbeddingData::getEmbedding).filter(Objects::nonNull).collect(Collectors.toList());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to fetch embedding", e);
                }
            }
            response.close();
        }
        return list;
    }

    private Request buildEmbeddingsRequest(String url, EmbeddingRequest request) throws JsonProcessingException {
        return new Request.Builder().url(url).headers(Headers.of(this.getHeaders())).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
    }

    public Request buildImageRequest(OpenAIImageGenerationRequest imageRequest) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getHeaders());
        headers.put("Content-Type", "application/json");
        try {
            String overriddenPath = imageRequest.getOverriddenPath();
            return new Request.Builder().url(this.host + (overriddenPath == null ? "/v1/images/generations" : overriddenPath)).headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)imageRequest), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Request buildChatCompletionRequest(OpenAIChatCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getHeaders());
        if (request.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        try {
            String overriddenPath = request.getOverriddenPath();
            return new Request.Builder().url(this.host + (overriddenPath == null ? "/v1/chat/completions" : overriddenPath)).headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Request buildTextCompletionRequest(OpenAITextCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getHeaders());
        if (request.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        try {
            return new Request.Builder().url(this.host + "/v1/completions").headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(Map.of("X-LLM-Application-Tag", "codegpt"));
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            headers.put("Authorization", "Bearer " + this.apiKey);
        }
        if (this.pluginVersion != null && !this.pluginVersion.isEmpty()) {
            headers.put("X-Plugin-Version", this.pluginVersion);
        }
        if (this.organization != null && !this.organization.isEmpty()) {
            headers.put("OpenAI-Organization", this.organization);
        }
        return headers;
    }

    public static class Builder {
        private final String apiKey;
        private String host = PropertiesLoader.getValue("openai.baseUrl");
        private String organization;
        private String pluginVersion;

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setPluginVersion(String pluginVersion) {
            this.pluginVersion = pluginVersion;
            return this;
        }

        public OpenAIClient build(OkHttpClient.Builder builder) {
            return new OpenAIClient(this, builder);
        }

        public OpenAIClient build() {
            return this.build(new OkHttpClient.Builder());
        }
    }
}

