/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai.completion.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import ee.carlrobert.llm.client.openai.completion.OpenAIChatCompletionModel;
import ee.carlrobert.llm.client.openai.completion.request.OpenAIChatCompletionMessage;
import ee.carlrobert.llm.client.openai.completion.request.Prediction;
import ee.carlrobert.llm.client.openai.completion.request.ResponseFormat;
import ee.carlrobert.llm.client.openai.completion.request.Tool;
import ee.carlrobert.llm.completion.CompletionRequest;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAIChatCompletionRequest
implements CompletionRequest {
    private final String model;
    private final List<OpenAIChatCompletionMessage> messages;
    @JsonProperty(value="max_tokens")
    private final Integer maxTokens;
    @JsonProperty(value="max_completion_tokens")
    private final Integer maxCompletionTokens;
    private final Double temperature;
    @JsonProperty(value="frequency_penalty")
    private final Double frequencyPenalty;
    @JsonProperty(value="presence_penalty")
    private final Double presencePenalty;
    private final boolean stream;
    @JsonIgnore
    private final String overriddenPath;
    private final List<Tool> tools;
    @JsonProperty(value="tool_choice")
    private final String toolChoice;
    @JsonProperty(value="response_format")
    private final ResponseFormat responseFormat;
    private final List<String> stop;
    private final Prediction prediction;
    @JsonProperty(value="reasoning_effort")
    private final String reasoningEffort;
    @JsonProperty(value="rewrite_speculation")
    private final Boolean rewriteSpeculation;

    private OpenAIChatCompletionRequest(Builder builder) {
        this.model = builder.model;
        this.messages = builder.messages;
        this.maxTokens = builder.maxTokens;
        this.maxCompletionTokens = builder.maxCompletionTokens;
        this.temperature = builder.temperature;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.presencePenalty = builder.presencePenalty;
        this.stream = builder.stream;
        this.overriddenPath = builder.overriddenPath;
        this.tools = builder.tools;
        this.toolChoice = builder.toolChoice;
        this.responseFormat = builder.responseFormat;
        this.stop = builder.stop;
        this.prediction = builder.prediction;
        this.reasoningEffort = builder.reasoningEffort;
        this.rewriteSpeculation = builder.rewriteSpeculation;
    }

    public void addMessage(OpenAIChatCompletionMessage message) {
        this.messages.add(message);
    }

    public List<OpenAIChatCompletionMessage> getMessages() {
        return this.messages;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public boolean isStream() {
        return this.stream;
    }

    public String getOverriddenPath() {
        return this.overriddenPath;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Prediction getPrediction() {
        return this.prediction;
    }

    public String getReasoningEffort() {
        return this.reasoningEffort;
    }

    public Boolean getRewriteSpeculation() {
        return this.rewriteSpeculation;
    }

    public static class Builder {
        private final List<OpenAIChatCompletionMessage> messages;
        private String model;
        private Integer maxTokens = 4096;
        private Integer maxCompletionTokens;
        private Double temperature = 0.9;
        private Double frequencyPenalty = 0.0;
        private Double presencePenalty = 0.6;
        private boolean stream = true;
        private String overriddenPath;
        private List<Tool> tools;
        private String toolChoice;
        private List<String> stop;
        private ResponseFormat responseFormat;
        private Prediction prediction;
        private String reasoningEffort;
        private Boolean rewriteSpeculation;

        public Builder(List<OpenAIChatCompletionMessage> messages) {
            this.messages = messages;
        }

        public Builder setModel(OpenAIChatCompletionModel model) {
            this.model = model.getCode();
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder setMaxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder setMaxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public Builder setTemperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder setFrequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder setPresencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder setStream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder setOverriddenPath(String overriddenPath) {
            this.overriddenPath = overriddenPath;
            return this;
        }

        public Builder setTools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        public Builder setToolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public Builder setStop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder setResponseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder setPrediction(Prediction prediction) {
            this.prediction = prediction;
            return this;
        }

        public Builder setReasoningEffort(String reasoningEffort) {
            this.reasoningEffort = reasoningEffort;
            return this;
        }

        public Builder setRewriteSpeculation(Boolean rewriteSpeculation) {
            this.rewriteSpeculation = rewriteSpeculation;
            return this;
        }

        public OpenAIChatCompletionRequest build() {
            return new OpenAIChatCompletionRequest(this);
        }
    }
}

