/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai.imagegen;

import ee.carlrobert.llm.imagegen.ImageGenerationModel;
import java.util.Arrays;

public enum OpenAIImageGenerationModel implements ImageGenerationModel
{
    DALL_E_2("dall-e-2", "DALL\u00b7E 2"),
    DALL_E_3("dall-e-3", "DALL\u00b7E 3");

    private final String code;
    private final String description;

    private OpenAIImageGenerationModel(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public static OpenAIImageGenerationModel findByCode(String code) {
        return Arrays.stream(OpenAIImageGenerationModel.values()).filter(item -> item.getCode().equals(code)).findFirst().orElseThrow();
    }
}

