/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client;

import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

public class InterceptorUtil {
    public static final Interceptor REWRITE_X_NDJSON_CONTENT_INTERCEPTOR = chain -> {
        Response response = chain.proceed(chain.request());
        if ("application/x-ndjson".equals(response.header("Content-Type", ""))) {
            try (ResponseBody originalBody = response.body();){
                Response response2;
                if (originalBody == null) {
                    Response response3 = response;
                    return response3;
                }
                BufferedSource source = originalBody.source();
                try (Buffer buffer = new Buffer();){
                    while (!source.exhausted()) {
                        String line = source.readUtf8LineStrict();
                        buffer.writeUtf8("data: ").writeUtf8(line).writeUtf8("\n\n");
                    }
                    response2 = response.newBuilder().header("Content-Type", "text/event-stream").body(ResponseBody.create((ByteString)buffer.readByteString(), (MediaType)MediaType.parse((String)"text/event-stream"))).build();
                }
                return response2;
            }
        }
        return response;
    };
}

