/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.codegpt;

import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.DeserializationUtil;
import ee.carlrobert.llm.client.codegpt.CodeGPTApiResponseError;
import ee.carlrobert.llm.client.codegpt.CodeGPTUserDetails;
import ee.carlrobert.llm.client.codegpt.request.AutoApplyRequest;
import ee.carlrobert.llm.client.codegpt.request.CodeCompletionRequest;
import ee.carlrobert.llm.client.codegpt.request.chat.ChatCompletionRequest;
import ee.carlrobert.llm.client.codegpt.request.prediction.AutocompletionPredictionRequest;
import ee.carlrobert.llm.client.codegpt.request.prediction.DirectPredictionRequest;
import ee.carlrobert.llm.client.codegpt.request.prediction.PastePredictionRequest;
import ee.carlrobert.llm.client.codegpt.response.AutoApplyResponse;
import ee.carlrobert.llm.client.codegpt.response.CodeGPTException;
import ee.carlrobert.llm.client.codegpt.response.PredictionResponse;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.client.openai.completion.OpenAIChatCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.OpenAITextCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.response.OpenAIChatCompletionResponse;
import ee.carlrobert.llm.completion.CompletionEventListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class CodeGPTClient {
    private static final String BASE_URL = PropertiesLoader.getValue("codegpt.baseUrl");
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private final OkHttpClient httpClient;
    private final String apiKey;

    public CodeGPTClient(String apiKey) {
        this(apiKey, new OkHttpClient.Builder());
    }

    public CodeGPTClient(String apiKey, OkHttpClient.Builder httpClientBuilder) {
        this.apiKey = apiKey;
        this.httpClient = httpClientBuilder.build();
    }

    public CodeGPTUserDetails getUserDetails(String apiKey) {
        CodeGPTUserDetails codeGPTUserDetails;
        block8: {
            Response response = this.httpClient.newCall(this.buildUserDetailsRequest(apiKey)).execute();
            try {
                codeGPTUserDetails = DeserializationUtil.mapResponse(response, CodeGPTUserDetails.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to fetch user details", e);
                }
            }
            response.close();
        }
        return codeGPTUserDetails;
    }

    public EventSource getChatCompletionAsync(ChatCompletionRequest request, CompletionEventListener<String> eventListener) {
        return this.createNewEventSource(this.buildChatCompletionRequest(request), this.getChatCompletionEventSourceListener(eventListener));
    }

    public EventSource getCodeCompletionAsync(CodeCompletionRequest request, CompletionEventListener<String> eventListener) {
        return this.createNewEventSource(this.buildCodeCompletionRequest(request), this.getCodeCompletionEventSourceListener(eventListener));
    }

    public OpenAIChatCompletionResponse getChatCompletion(ChatCompletionRequest request) {
        OpenAIChatCompletionResponse openAIChatCompletionResponse;
        block10: {
            Response response = this.httpClient.newCall(this.buildChatCompletionRequest(request)).execute();
            try {
                if (!response.isSuccessful()) {
                    ResponseBody body = response.body();
                    if (body == null) {
                        throw new RuntimeException("Unable to get response body");
                    }
                    throw (CodeGPTException)DeserializationUtil.OBJECT_MAPPER.readValue(body.string(), CodeGPTException.class);
                }
                openAIChatCompletionResponse = DeserializationUtil.mapResponse(response, OpenAIChatCompletionResponse.class);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to get chat completion", e);
                }
            }
            response.close();
        }
        return openAIChatCompletionResponse;
    }

    public AutoApplyResponse applySuggestedChanges(AutoApplyRequest request) {
        AutoApplyResponse autoApplyResponse;
        block8: {
            Response response = this.httpClient.newCall(this.buildAutoApplyRequest(request)).execute();
            try {
                autoApplyResponse = DeserializationUtil.mapResponse(response, AutoApplyResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to apply suggested changes", e);
                }
            }
            response.close();
        }
        return autoApplyResponse;
    }

    public Request buildAutocompletionPredictionRequest(AutocompletionPredictionRequest request) {
        return this.buildPredictionRequest("/v1/predictions/autocompletion", request);
    }

    public Request buildLookupPredictionRequest(AutocompletionPredictionRequest request) {
        return this.buildPredictionRequest("/v1/predictions/lookup", request);
    }

    public Request buildDirectPredictionRequest(DirectPredictionRequest request) {
        return this.buildPredictionRequest("/v1/predictions/direct", request);
    }

    public Request buildPastePredictionRequest(PastePredictionRequest request) {
        return this.buildPredictionRequest("/v1/predictions/paste", request);
    }

    public PredictionResponse getPrediction(Call call) {
        PredictionResponse predictionResponse;
        block8: {
            Response response = call.execute();
            try {
                predictionResponse = DeserializationUtil.mapResponse(response, PredictionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to get prediction response", e);
                }
            }
            response.close();
        }
        return predictionResponse;
    }

    public Call createNewCall(Request request) {
        return this.httpClient.newCall(request);
    }

    private EventSource createNewEventSource(Request request, EventSourceListener eventSourceListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(request, eventSourceListener);
    }

    private Request buildChatCompletionRequest(ChatCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        try {
            return new Request.Builder().url(BASE_URL + "/v1/chat/completions").headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Request buildCodeCompletionRequest(CodeCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        try {
            return new Request.Builder().url(BASE_URL + "/v1/code/completions").headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Request buildUserDetailsRequest(String apiKey) {
        return new Request.Builder().url(BASE_URL + "/v1/users/details").header("Authorization", "Bearer " + apiKey).get().build();
    }

    private Request buildAutoApplyRequest(AutoApplyRequest request) {
        try {
            return new Request.Builder().url(BASE_URL + "/v1/files/apply-changes").header("Authorization", "Bearer " + this.apiKey).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to build file diff request", e);
        }
    }

    private Request buildPredictionRequest(String url, Object request) {
        try {
            return new Request.Builder().url(BASE_URL + url).header("Authorization", "Bearer " + this.apiKey).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString(request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to build generic prediction request", e);
        }
    }

    private Map<String, String> getRequiredHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(Map.of("X-LLM-Application-Tag", "codegpt", "Accept", "text/event-stream"));
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            headers.put("Authorization", "Bearer " + this.apiKey);
        }
        return headers;
    }

    private OpenAIChatCompletionEventSourceListener getChatCompletionEventSourceListener(CompletionEventListener<String> listener) {
        return new OpenAIChatCompletionEventSourceListener(listener){

            @Override
            protected ErrorDetails getErrorDetails(String data) throws JsonProcessingException {
                return ((CodeGPTApiResponseError)DeserializationUtil.OBJECT_MAPPER.readValue(data, CodeGPTApiResponseError.class)).getError();
            }
        };
    }

    private OpenAITextCompletionEventSourceListener getCodeCompletionEventSourceListener(CompletionEventListener<String> listener) {
        return new OpenAITextCompletionEventSourceListener(listener){

            @Override
            protected ErrorDetails getErrorDetails(String data) throws JsonProcessingException {
                return ((CodeGPTApiResponseError)DeserializationUtil.OBJECT_MAPPER.readValue(data, CodeGPTApiResponseError.class)).getError();
            }
        };
    }
}

