/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai.completion.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Base64;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAIImageUrl {
    private String url;
    private ImageDetail detail;

    public OpenAIImageUrl(String mediaType, byte[] imageData, ImageDetail detail) {
        this.setImageUrl(mediaType, imageData);
        this.detail = detail;
    }

    public OpenAIImageUrl(String mediaType, byte[] imageData) {
        this.setImageUrl(mediaType, imageData);
    }

    public OpenAIImageUrl(String imageUrl, ImageDetail detail) {
        this.url = imageUrl;
        this.detail = detail;
    }

    public OpenAIImageUrl(String imageUrl) {
        this.url = imageUrl;
    }

    public OpenAIImageUrl() {
    }

    public ImageDetail getDetail() {
        return this.detail;
    }

    public void setDetail(ImageDetail detail) {
        this.detail = detail;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonIgnore
    public void setImageUrl(String mediaType, byte[] imageData) {
        this.url = "data:" + mediaType + ";base64," + Base64.getEncoder().encodeToString(imageData);
    }

    public static enum ImageDetail {
        HIGH("high"),
        LOW("low"),
        AUTO("auto");

        private final String detail;

        private ImageDetail(String detail) {
            this.detail = detail;
        }

        @JsonValue
        public String getDetail() {
            return this.detail;
        }
    }
}

