/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.google.models;

import java.util.Arrays;

public enum GoogleModel {
    GEMINI_1_0_PRO_VISION_LATEST("gemini-1.0-pro-vision-latest", "Gemini 1.0 Pro Vision Latest (16k)", 16384),
    GEMINI_1_5_PRO("gemini-1.5-pro", "Gemini 1.5 Pro", 2008192),
    GEMINI_2_0_FLASH("gemini-2.0-flash", "Gemini 2.0 Flash", 2008192),
    GEMINI_2_5_FLASH("gemini-2.5-flash", "Gemini 2.5 Flash", 0x100000),
    GEMINI_2_0_FLASH_THINKING_EXP("gemini-2.0-flash-thinking-exp-01-21", "Gemini 2.0 Flash Thinking (Experimental)", 2008192, true),
    GEMINI_2_0_PRO_EXP("gemini-2.0-pro-exp-02-05", "Gemini 2.0 Pro (Experimental)", 2008192, true),
    GEMINI_2_5_PRO_PREVIEW("gemini-2.5-pro-preview-06-05", "Gemini 2.5 Pro (Preview)", 0x100000, true),
    GEMINI_2_5_PRO("gemini-2.5-pro", "Gemini 2.5 Pro", 0x100000),
    GEMINI_2_5_FLASH_PREVIEW("gemini-2.5-flash-preview-05-20", "Gemini 2.5 Flash (Preview)", 0x100000, true),
    GEMINI_2_5_FLASH_LITE_PREVIEW("gemini-2.5-flash-lite-preview-06-17", "Gemini 2.5 Flash Lite (Preview)", 1000000, true),
    GEMINI_PRO_VISION("gemini-pro-vision", "Gemini Pro Vision (16k)", 16384),
    EMBEDDING_001("embedding-001", "Embedding 001 (2k)", 2049),
    TEXT_EMBEDDING_004("text-embedding-004", "Text Embedding (2k)", 2049);

    private final String code;
    private final String description;
    private final int maxTokens;
    private final boolean experimental;

    private GoogleModel(String code, String description, int maxTokens) {
        this(code, description, maxTokens, false);
    }

    private GoogleModel(String code, String description, int maxTokens, boolean experimental) {
        this.code = code;
        this.description = description;
        this.maxTokens = maxTokens;
        this.experimental = experimental;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public String toString() {
        return this.description;
    }

    public static GoogleModel findByCode(String code) {
        return Arrays.stream(GoogleModel.values()).filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }
}

