/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.mistral;

import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.llm.PropertiesLoader;
import ee.carlrobert.llm.client.DeserializationUtil;
import ee.carlrobert.llm.client.codegpt.CodeGPTApiResponseError;
import ee.carlrobert.llm.client.codegpt.response.CodeGPTException;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.client.openai.completion.OpenAIChatCompletionEventSourceListener;
import ee.carlrobert.llm.client.openai.completion.request.OpenAIChatCompletionRequest;
import ee.carlrobert.llm.client.openai.completion.request.OpenAITextCompletionRequest;
import ee.carlrobert.llm.client.openai.completion.response.OpenAIChatCompletionResponse;
import ee.carlrobert.llm.completion.CompletionEventListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public class MistralClient {
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private final String host = PropertiesLoader.getValue("mistral.baseUrl");
    private final OkHttpClient httpClient;
    private final String apiKey;

    public MistralClient(String apiKey, OkHttpClient.Builder httpClientBuilder) {
        this.httpClient = httpClientBuilder.build();
        this.apiKey = apiKey;
    }

    public EventSource getChatCompletionAsync(OpenAIChatCompletionRequest request, CompletionEventListener<String> eventListener) {
        return this.createNewEventSource(this.buildChatCompletionRequest(request), this.getChatCompletionEventSourceListener(eventListener));
    }

    public OpenAIChatCompletionResponse getChatCompletion(OpenAIChatCompletionRequest request) {
        OpenAIChatCompletionResponse openAIChatCompletionResponse;
        block10: {
            Response response = this.httpClient.newCall(this.buildChatCompletionRequest(request)).execute();
            try {
                if (!response.isSuccessful()) {
                    ResponseBody body = response.body();
                    if (body == null) {
                        throw new RuntimeException("Unable to get response body");
                    }
                    throw (CodeGPTException)DeserializationUtil.OBJECT_MAPPER.readValue(body.string(), CodeGPTException.class);
                }
                openAIChatCompletionResponse = DeserializationUtil.mapResponse(response, OpenAIChatCompletionResponse.class);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to get chat completion", e);
                }
            }
            response.close();
        }
        return openAIChatCompletionResponse;
    }

    public EventSource getCodeCompletionAsync(OpenAITextCompletionRequest request, CompletionEventListener<String> eventListener) {
        return this.createNewEventSource(this.buildCodeCompletionRequest(request), this.getCodeCompletionEventSourceListener(eventListener));
    }

    private EventSource createNewEventSource(Request request, EventSourceListener eventSourceListener) {
        return EventSources.createFactory((OkHttpClient)this.httpClient).newEventSource(request, eventSourceListener);
    }

    private Request buildChatCompletionRequest(OpenAIChatCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getHeaders());
        if (request.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        try {
            String overriddenPath = request.getOverriddenPath();
            return new Request.Builder().url(this.host + (overriddenPath == null ? "/v1/chat/completions" : overriddenPath)).headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Request buildCodeCompletionRequest(OpenAITextCompletionRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getHeaders());
        try {
            return new Request.Builder().url(this.host + "/v1/fim/completions").headers(Headers.of(headers)).post(RequestBody.create((String)DeserializationUtil.OBJECT_MAPPER.writeValueAsString((Object)request), (MediaType)APPLICATION_JSON)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to process request", e);
        }
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(Map.of("X-LLM-Application-Tag", "codegpt"));
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            headers.put("Authorization", "Bearer " + this.apiKey);
        }
        return headers;
    }

    private OpenAIChatCompletionEventSourceListener getChatCompletionEventSourceListener(CompletionEventListener<String> listener) {
        return new OpenAIChatCompletionEventSourceListener(listener){

            @Override
            protected ErrorDetails getErrorDetails(String data) throws JsonProcessingException {
                return ((CodeGPTApiResponseError)DeserializationUtil.OBJECT_MAPPER.readValue(data, CodeGPTApiResponseError.class)).getError();
            }
        };
    }

    private OpenAIChatCompletionEventSourceListener getCodeCompletionEventSourceListener(CompletionEventListener<String> listener) {
        return new OpenAIChatCompletionEventSourceListener(listener){

            @Override
            protected ErrorDetails getErrorDetails(String data) throws JsonProcessingException {
                return ((CodeGPTApiResponseError)DeserializationUtil.OBJECT_MAPPER.readValue(data, CodeGPTApiResponseError.class)).getError();
            }
        };
    }
}

