/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai.imagegen.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import ee.carlrobert.llm.imagegen.ImageGenerationRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAIImageGenerationRequest
implements ImageGenerationRequest {
    @JsonProperty(value="prompt")
    private final String prompt;
    @JsonProperty(value="model")
    private final String model;
    @JsonProperty(value="size")
    private final ImageSize size;
    @JsonProperty(value="n")
    private final int numberOfImages;
    @JsonProperty(value="response_format")
    private final ImagesResponseFormat responseFormat;
    @JsonProperty(value="quality")
    private final ImageQuality quality;
    @JsonProperty(value="style")
    private final ImageStyle style;
    @JsonIgnore
    private final String overriddenPath;

    private OpenAIImageGenerationRequest(Builder builder) {
        this.prompt = builder.prompt;
        this.size = builder.size;
        this.style = builder.style;
        this.responseFormat = builder.responseFormat;
        this.quality = builder.quality;
        this.numberOfImages = builder.numberOfImages;
        this.overriddenPath = builder.overriddenPath;
        this.model = builder.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public ImageSize getSize() {
        return this.size;
    }

    public int getNumberOfImages() {
        return this.numberOfImages;
    }

    public ImagesResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public ImageQuality getQuality() {
        return this.quality;
    }

    public ImageStyle getStyle() {
        return this.style;
    }

    public String getModel() {
        return this.model;
    }

    @JsonIgnore
    public String getOverriddenPath() {
        return this.overriddenPath;
    }

    public static enum ImageSize {
        LANDSCAPE_1792_1024("1792x1024"),
        PORTRAIT_1024_1792("1024x1792"),
        SQUARE_1024_1024("1024x1024");

        private final String size;

        private ImageSize(String size) {
            this.size = size;
        }

        @JsonValue
        public String getSize() {
            return this.size;
        }
    }

    public static enum ImagesResponseFormat {
        URL("url"),
        BASE_64_JSON("b64_json");

        private final String responseFormat;

        private ImagesResponseFormat(String detail) {
            this.responseFormat = detail;
        }

        @JsonValue
        public String getResponseFormat() {
            return this.responseFormat;
        }
    }

    public static enum ImageStyle {
        VIVID("vivid"),
        NATURAL("natural");

        private final String style;

        private ImageStyle(String detail) {
            this.style = detail;
        }

        @JsonValue
        public String getStyle() {
            return this.style;
        }
    }

    public static enum ImageQuality {
        STANDARD("standard"),
        HD("hd");

        private final String quality;

        private ImageQuality(String detail) {
            this.quality = detail;
        }

        @JsonValue
        public String getQuality() {
            return this.quality;
        }
    }

    public static class Builder {
        private String prompt;
        private ImageSize size;
        private int numberOfImages;
        private ImagesResponseFormat responseFormat;
        private ImageQuality quality;
        private ImageStyle style;
        private String overriddenPath;
        private String model;

        public Builder(String prompt) {
            this.prompt = prompt;
            this.numberOfImages = 1;
        }

        public Builder setNumberOfImages(int numberOfImages) {
            this.numberOfImages = numberOfImages;
            return this;
        }

        public Builder setPrompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder setSize(ImageSize size) {
            this.size = size;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder setResponseFormat(ImagesResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder setQuality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public Builder setStyle(ImageStyle style) {
            this.style = style;
            return this;
        }

        public OpenAIImageGenerationRequest build() {
            return new OpenAIImageGenerationRequest(this);
        }

        public void setOverriddenPath(String overriddenPath) {
            this.overriddenPath = overriddenPath;
        }
    }
}

