/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.openai.imagegen.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import ee.carlrobert.llm.client.openai.completion.ErrorDetails;
import ee.carlrobert.llm.imagegen.ImageGenerationResponse;
import java.util.Base64;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenAiImageGenerationResponse
implements ImageGenerationResponse {
    @JsonProperty(value="data")
    private final List<OpenAiImageGenerationResponseData> data;
    @JsonIgnore
    private final Date created;
    @JsonProperty(value="error")
    private final ErrorDetails error;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public OpenAiImageGenerationResponse(@JsonProperty(value="data") List<OpenAiImageGenerationResponseData> data, @JsonProperty(value="created") Long created, @JsonProperty(value="error") ErrorDetails error) {
        this.data = data;
        this.created = created == null ? null : new Date(created * 1000L);
        this.error = error;
    }

    public List<OpenAiImageGenerationResponseData> getData() {
        return this.data;
    }

    public ErrorDetails getError() {
        return this.error;
    }

    @JsonIgnore
    public Date getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    public Long getCreatedAsLong() {
        if (this.created == null) {
            return null;
        }
        return this.created.getTime() / 1000L;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OpenAiImageGenerationResponseData
    implements ImageGenerationResponse {
        @JsonProperty(value="url")
        private final String url;
        @JsonIgnore
        private final byte[] imageData;
        @JsonProperty(value="revised_prompt")
        private final String revisedPrompt;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        public OpenAiImageGenerationResponseData(@JsonProperty(value="url") String url, @JsonProperty(value="b64_json") String base64json, @JsonProperty(value="revised_prompt") String revisedPrompt) {
            this.url = url;
            this.imageData = base64json == null ? null : Base64.getDecoder().decode(base64json);
            this.revisedPrompt = revisedPrompt;
        }

        public String getUrl() {
            return this.url;
        }

        @JsonIgnore
        public byte[] getImageData() {
            return this.imageData;
        }

        @JsonProperty(value="b64_json")
        public String getImageDataBase64() {
            return this.imageData == null ? null : Base64.getEncoder().encodeToString(this.imageData);
        }

        public String getRevisedPrompt() {
            return this.revisedPrompt;
        }
    }
}

