/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.you.completion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import ee.carlrobert.llm.client.you.completion.YouSerpResult;
import ee.carlrobert.llm.client.you.completion.YouSourceResult;
import ee.carlrobert.llm.client.you.completion.YouThirdPartySearchResult;
import ee.carlrobert.llm.completion.CompletionResponse;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class YouCompletionResponse
implements CompletionResponse {
    private final String chatToken;
    private final String altChatToken;
    private final String section;
    private final boolean sectionDone;
    private final YouSourceResult sourceResult;
    private final List<YouSerpResult> serpResults;
    private final List<String> relatedSearches;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public YouCompletionResponse(@JsonProperty(value="youChatToken") String chatToken, @JsonProperty(value="youChatSerpResults") List<YouSerpResult> serpResults, @JsonProperty(value="t") String altChatToken, @JsonProperty(value="msg") String section, @JsonProperty(value="done") boolean sectionDone, @JsonProperty(value="relatedSearches") List<String> relatedSearches, @JsonProperty(value="search") YouThirdPartySearchResult thirdPartySearchResult, @JsonProperty(value="source") YouSourceResult sourceResult) {
        this.chatToken = chatToken;
        this.altChatToken = altChatToken;
        this.section = section;
        this.sectionDone = sectionDone;
        this.relatedSearches = relatedSearches;
        this.sourceResult = sourceResult;
        this.serpResults = serpResults != null && !serpResults.isEmpty() ? serpResults : (thirdPartySearchResult != null && thirdPartySearchResult.hasSearchResults() ? thirdPartySearchResult.getThirdPartySearchResults() : null);
    }

    public String getChatToken() {
        if (this.chatToken != null) {
            return this.chatToken;
        }
        if (this.altChatToken != null) {
            return this.altChatToken;
        }
        if (this.section != null && !this.sectionDone) {
            return "\n**" + this.section + "**\n\n";
        }
        if (this.relatedSearches != null) {
            return "\n**Related searches**\n\n" + this.relatedSearches.stream().map(element -> "* " + element + "\n").collect(Collectors.joining());
        }
        if (this.sourceResult != null && this.sourceResult.isValid()) {
            return "* " + this.sourceResult.toString() + "\n";
        }
        return null;
    }

    public List<YouSerpResult> getSerpResults() {
        return this.serpResults;
    }
}

