/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.llm.client.you.completion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;

@JsonIgnoreProperties(ignoreUnknown=true)
public class YouSourceResult {
    private final String url;
    private final boolean done;
    private final boolean isError;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public YouSourceResult(@JsonProperty(value="url") String url, @JsonProperty(value="done") boolean done, @JsonProperty(value="isError") boolean isError) {
        this.url = url;
        this.done = done;
        this.isError = isError;
    }

    public boolean isValid() {
        return this.done && !this.isError;
    }

    public String toString() {
        try {
            URL parsedUrl = new URL(this.url);
            String hostName = parsedUrl.getHost();
            return "[" + hostName + "](" + parsedUrl.toString() + ")";
        }
        catch (Exception e) {
            return this.url;
        }
    }
}

