/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.completion;

import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.openai.client.Client;
import ee.carlrobert.openai.client.ClientCode;
import ee.carlrobert.openai.client.completion.CompletionEventListener;
import ee.carlrobert.openai.client.completion.CompletionEventSourceListener;
import ee.carlrobert.openai.client.completion.CompletionRequest;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public abstract class CompletionClient {
    private final Client client;
    private final String url;

    public CompletionClient(Client client, String host, String path) {
        this.client = client;
        this.url = host + path;
    }

    protected abstract Map<String, String> getRequiredHeaders();

    protected abstract CompletionEventSourceListener getEventListener(CompletionEventListener var1);

    public abstract ClientCode getClientCode();

    public <T extends CompletionRequest> EventSource stream(T requestBody, CompletionEventListener listeners) {
        return this.createNewEventSource(requestBody, listeners);
    }

    protected <T> Request buildRequest(T requestBody) {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        headers.put("Accept", "text/event-stream");
        try {
            return new Request.Builder().url(this.url).headers(Headers.of(headers)).post(RequestBody.create((String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(requestBody), (MediaType)MediaType.parse((String)"application/json"))).build();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to serialize request payload");
        }
    }

    protected <T> EventSource createNewEventSource(T requestBody, CompletionEventListener listeners) {
        return EventSources.createFactory((OkHttpClient)this.client.buildHttpClient()).newEventSource(this.buildRequest(requestBody), (EventSourceListener)this.getEventListener(listeners));
    }
}

