/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.completion;

import com.fasterxml.jackson.core.JsonProcessingException;
import ee.carlrobert.openai.client.completion.CompletionEventListener;
import ee.carlrobert.openai.client.completion.ErrorDetails;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.StreamResetException;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompletionEventSourceListener
extends EventSourceListener {
    private static final Logger LOG = LoggerFactory.getLogger(CompletionEventSourceListener.class);
    private final CompletionEventListener listeners;
    private final StringBuilder messageBuilder = new StringBuilder();

    public CompletionEventSourceListener(CompletionEventListener listeners) {
        this.listeners = listeners;
    }

    protected abstract String getMessage(String var1) throws JsonProcessingException;

    protected abstract ErrorDetails getErrorDetails(String var1) throws JsonProcessingException;

    public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
        LOG.info("Request opened.");
    }

    public void onClosed(@NotNull EventSource eventSource) {
        LOG.info("Request closed.");
        this.listeners.onComplete(this.messageBuilder);
    }

    public void onEvent(@NotNull EventSource eventSource, String id, String type, @NotNull String data) {
        try {
            if ("[DONE]".equals(data)) {
                return;
            }
            String message = this.getMessage(data);
            if (message != null) {
                this.messageBuilder.append(message);
                this.listeners.onMessage(message);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to deserialize payload.", e);
        }
    }

    public void onFailure(@NotNull EventSource eventSource, Throwable ex, Response response) {
        if (ex instanceof StreamResetException) {
            LOG.info("Stream was cancelled");
            this.listeners.onComplete(this.messageBuilder);
            return;
        }
        if (ex instanceof SocketTimeoutException) {
            this.listeners.onError(new ErrorDetails("Request timed out. This may be due to the server being overloaded."));
            return;
        }
        try {
            if (response == null) {
                throw new IOException(ex);
            }
            ResponseBody body = response.body();
            if (body != null) {
                String jsonBody = body.string();
                ErrorDetails errorDetails = this.getErrorDetails(jsonBody);
                if (errorDetails == null || errorDetails.getMessage() == null || errorDetails.getMessage().isEmpty()) {
                    this.listeners.onError(new ErrorDetails(String.format("Unknown API response. Code: %s, Body: %s", response.code(), jsonBody)));
                } else {
                    this.listeners.onError(errorDetails);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Something went wrong.", (Throwable)e);
            this.listeners.onError(ErrorDetails.DEFAULT_ERROR);
        }
    }
}

