/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.completion;

import com.fasterxml.jackson.annotation.JsonProperty;

public abstract class CompletionRequest {
    @JsonProperty(value="max_tokens")
    private final int maxTokens;
    private final double temperature;
    @JsonProperty(value="frequency_penalty")
    private final double frequencyPenalty;
    @JsonProperty(value="presence_penalty")
    private final double presencePenalty;

    protected CompletionRequest(Builder builder) {
        this.maxTokens = builder.maxTokens;
        this.temperature = builder.temperature;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.presencePenalty = builder.presencePenalty;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public boolean isStream() {
        return true;
    }

    public static abstract class Builder {
        private int maxTokens = 1000;
        private double temperature = 0.9;
        private double frequencyPenalty = 0.0;
        private double presencePenalty = 0.6;

        public Builder setMaxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder setTemperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder setFrequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder setPresencePenalty(double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public abstract CompletionRequest build();
    }
}

