/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.completion.text;

import ee.carlrobert.openai.client.completion.CompletionModel;
import java.util.Arrays;

public enum TextCompletionModel implements CompletionModel
{
    ADA("text-ada-001", "Ada - Fastest", 2049),
    BABBAGE("text-babbage-001", "Babbage - Powerful", 2049),
    CURIE("text-curie-001", "Curie - Fast and efficient", 2049),
    DAVINCI("text-davinci-003", "Davinci - Most powerful (Default)", 4097);

    private final String code;
    private final String description;
    private final int maxTokens;

    private TextCompletionModel(String code, String description, int maxTokens) {
        this.code = code;
        this.description = description;
        this.maxTokens = maxTokens;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getMaxTokens() {
        return this.maxTokens;
    }

    public static TextCompletionModel findByCode(String code) {
        return Arrays.stream(TextCompletionModel.values()).filter(item -> item.getCode().equals(code)).findFirst().orElseThrow();
    }
}

