/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import ee.carlrobert.openai.http.RequestEntity;
import ee.carlrobert.openai.http.ResponseEntity;
import ee.carlrobert.openai.http.expectation.BasicExpectation;
import ee.carlrobert.openai.http.expectation.Expectation;
import ee.carlrobert.openai.http.expectation.StreamExpectation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCallbackServer {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCallbackServer.class);
    private final AtomicInteger currentExpectationIndex = new AtomicInteger();
    private final List<Expectation> expectations = new CopyOnWriteArrayList<Expectation>();
    private final HttpServer server;

    public LocalCallbackServer() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(8000), 0);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create HttpServer", e);
        }
        this.server.setExecutor(null);
        this.server.createContext("/", exchange -> {
            try {
                Expectation expectation = this.expectations.get(this.currentExpectationIndex.getAndIncrement());
                if (!expectation.getPath().equals(exchange.getRequestURI().getPath())) {
                    try {
                        try {
                            throw new AssertionError((Object)String.format("Expecting request path to be \"%s\", but received \"%s\"", expectation.getPath(), exchange.getRequestURI().getPath()));
                        }
                        catch (AssertionError e) {
                            ((Throwable)((Object)e)).printStackTrace();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        exchange.sendResponseHeaders(500, -1L);
                        exchange.getRequestBody().close();
                        throw throwable;
                    }
                }
                if (expectation instanceof StreamExpectation) {
                    this.handleStreamExchange((StreamExpectation)expectation, exchange);
                } else {
                    this.handleExchange((BasicExpectation)expectation, exchange);
                }
            }
            catch (Throwable e) {
                LOG.error("Request failed", e);
                throw e;
            }
            finally {
                exchange.close();
            }
        });
        this.server.start();
    }

    public void addExpectation(Expectation expectation) {
        this.expectations.add(expectation);
    }

    public void stop() {
        this.server.stop(0);
    }

    private void handleExchange(BasicExpectation expectation, HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().add("Content-Type", "application/json");
        ResponseEntity response = expectation.getExchange().getResponse(new RequestEntity(exchange));
        exchange.sendResponseHeaders(response.getStatusCode(), response.getResponse().length());
        OutputStream responseBody = exchange.getResponseBody();
        responseBody.write(response.getResponse().getBytes());
        responseBody.flush();
        responseBody.close();
    }

    private void handleStreamExchange(StreamExpectation expectation, HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().add("Content-Type", "text/event-stream");
        exchange.getResponseHeaders().add("Cache-Control", "no-cache");
        exchange.getResponseHeaders().add("Connection", "keep-alive");
        exchange.sendResponseHeaders(200, 0L);
        OutputStream responseBody = exchange.getResponseBody();
        for (String event : expectation.getExchange().getResponse(new RequestEntity(exchange))) {
            responseBody.write(String.format("data: %s\n\n", event).getBytes());
            LocalCallbackServer.sleep(250L);
        }
        responseBody.write("data: [DONE]\n\n".getBytes());
        responseBody.flush();
        responseBody.close();
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

