/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client;

import ee.carlrobert.openai.client.ProxyAuthenticator;
import ee.carlrobert.openai.client.completion.CompletionClient;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;

public class Client {
    final OkHttpClient httpClient;
    final String apiKey;
    final String host;
    final Proxy proxy;
    final ProxyAuthenticator proxyAuthenticator;
    final Long connectTimeout;
    final TimeUnit connectTimeoutUnit;
    final Long readTimeout;
    final TimeUnit readTimeoutUnit;
    final boolean retryOnReadTimeout;

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isRetryOnReadTimeout() {
        return this.retryOnReadTimeout;
    }

    protected Client(Builder builder) {
        this.httpClient = builder.buildHttpClient();
        this.apiKey = builder.apiKey;
        this.host = builder.host;
        this.proxy = builder.proxy;
        this.proxyAuthenticator = builder.proxyAuthenticator;
        this.connectTimeout = builder.connectTimeout;
        this.connectTimeoutUnit = builder.connectTimeoutUnit;
        this.readTimeout = builder.readTimeout;
        this.readTimeoutUnit = builder.readTimeoutUnit;
        this.retryOnReadTimeout = builder.retryOnReadTimeout;
    }

    public static class Builder {
        private final String apiKey;
        private String host;
        private Proxy proxy;
        private ProxyAuthenticator proxyAuthenticator;
        private Long connectTimeout;
        private TimeUnit connectTimeoutUnit;
        private Long readTimeout;
        private TimeUnit readTimeoutUnit;
        private boolean retryOnReadTimeout;

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder setProxyAuthenticator(ProxyAuthenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder setConnectTimeout(Long timeout, TimeUnit unit) {
            this.connectTimeout = timeout;
            this.connectTimeoutUnit = unit;
            return this;
        }

        public Builder setReadTimeout(Long timeout, TimeUnit unit) {
            this.readTimeout = timeout;
            this.readTimeoutUnit = unit;
            return this;
        }

        public Builder setRetryOnReadTimeout(boolean retryOnReadTimeout) {
            this.retryOnReadTimeout = retryOnReadTimeout;
            return this;
        }

        public CompletionClient buildChatCompletionClient() {
            throw new RuntimeException("Chat completion client not implemented!");
        }

        public CompletionClient buildTextCompletionClient() {
            throw new RuntimeException("Text completion client not implemented!");
        }

        public OkHttpClient buildHttpClient() {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (this.connectTimeout != null && this.connectTimeoutUnit != null) {
                builder.connectTimeout(this.connectTimeout.longValue(), this.connectTimeoutUnit);
            }
            if (this.readTimeout != null && this.readTimeoutUnit != null) {
                builder.readTimeout(this.readTimeout.longValue(), this.readTimeoutUnit);
            }
            if (this.proxy != null) {
                this.trustAllCertificates(builder);
                builder.proxy(this.proxy);
                if (this.proxyAuthenticator != null) {
                    builder.proxyAuthenticator((route, response) -> response.request().newBuilder().header("Proxy-Authorization", Credentials.basic((String)this.proxyAuthenticator.getUsername(), (String)this.proxyAuthenticator.getPassword())).build());
                }
            }
            return builder.build();
        }

        private void trustAllCertificates(OkHttpClient.Builder builder) {
            TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManager, new SecureRandom());
                builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManager[0]);
                builder.hostnameVerifier((hostname, session) -> true);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException("Something went wrong while attempting to trust all certificates: ", e);
            }
        }
    }
}

