/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.azure;

import ee.carlrobert.openai.PropertiesLoader;
import ee.carlrobert.openai.client.AzureClient;
import ee.carlrobert.openai.client.azure.AzureClientRequestParams;
import ee.carlrobert.openai.client.completion.CompletionClient;
import java.util.Map;

abstract class AzureCompletionClient
extends CompletionClient {
    private final AzureClient client;
    private static final String BASE_URL = PropertiesLoader.getValue("openai.azure.baseUrl");

    public AzureCompletionClient(AzureClient client, String path) {
        super(client, AzureCompletionClient.getHost(client), AzureCompletionClient.formatPath(client, path));
        this.client = client;
    }

    private static String formatPath(AzureClient client, String path) {
        AzureClientRequestParams params = client.getRequestParams();
        return String.format(path, params.getDeploymentId(), params.getApiVersion());
    }

    private static String getHost(AzureClient client) {
        return String.format(client.getHost() == null ? BASE_URL : client.getHost(), client.getRequestParams().getResourceName());
    }

    @Override
    protected Map<String, String> getRequiredHeaders() {
        return this.client.isActiveDirectoryAuthentication() ? Map.of("Authorization", "Bearer " + this.client.getApiKey()) : Map.of("api-key", this.client.getApiKey());
    }
}

