/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.completion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.openai.client.Client;
import ee.carlrobert.openai.client.ClientCode;
import ee.carlrobert.openai.client.completion.CompletionEventListener;
import ee.carlrobert.openai.client.completion.CompletionEventSourceListener;
import ee.carlrobert.openai.client.completion.CompletionRequest;
import ee.carlrobert.openai.client.completion.ErrorDetails;
import ee.carlrobert.openai.client.completion.chat.request.ChatCompletionMessage;
import ee.carlrobert.openai.client.completion.chat.request.ChatCompletionRequest;
import ee.carlrobert.openai.client.completion.text.request.TextCompletionRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

public abstract class CompletionClient {
    private static final int MAX_RETRY_COUNT = 3;
    private final Client client;
    private final String url;
    private int retryCounter = 0;

    public CompletionClient(Client client, String host, String path) {
        this.client = client;
        this.url = host + path;
    }

    protected abstract Map<String, String> getRequiredHeaders();

    protected abstract CompletionEventSourceListener getEventListener(CompletionEventListener var1, boolean var2, Consumer<String> var3);

    public abstract ClientCode getClientCode();

    public <T extends CompletionRequest> EventSource stream(T requestBody, CompletionEventListener listeners) {
        return this.createNewEventSource(requestBody, listeners);
    }

    public <T extends CompletionRequest> String call(T requestBody) {
        String string;
        block8: {
            Response response = this.client.getHttpClient().newCall(this.buildRequest(requestBody)).execute();
            try {
                string = Objects.requireNonNull(response.body()).string();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return string;
    }

    protected <T extends CompletionRequest> Request buildRequest(T requestBody) throws JsonProcessingException {
        HashMap<String, String> headers = new HashMap<String, String>(this.getRequiredHeaders());
        if (requestBody.isStream()) {
            headers.put("Accept", "text/event-stream");
        }
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(mapper.writeValueAsString(requestBody), (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map<String, ?> additionalParams = requestBody.getAdditionalParams();
        if (additionalParams != null && !additionalParams.isEmpty()) {
            map.putAll(additionalParams);
        }
        return new Request.Builder().url(this.url).headers(Headers.of(headers)).post(RequestBody.create((String)mapper.writeValueAsString((Object)map), (MediaType)MediaType.parse((String)"application/json"))).build();
    }

    protected <T extends CompletionRequest> EventSource createNewEventSource(T requestBody, CompletionEventListener listeners) {
        Request request;
        try {
            request = this.buildRequest(requestBody);
        }
        catch (JsonProcessingException e) {
            RuntimeException error = new RuntimeException("Unable to build request", e);
            listeners.onError(new ErrorDetails(e.getMessage()), error);
            throw error;
        }
        return EventSources.createFactory((OkHttpClient)this.client.getHttpClient()).newEventSource(request, (EventSourceListener)this.getEventListener(listeners, this.client.isRetryOnReadTimeout(), response -> {
            if (this.retryCounter > 3) {
                listeners.onError(new ErrorDetails("The server may be overloaded as the request has timed out for 3 times."), new RuntimeException());
                return;
            }
            if (requestBody instanceof ChatCompletionRequest) {
                ChatCompletionRequest body = (ChatCompletionRequest)requestBody;
                if (this.retryCounter == 0) {
                    body.addMessage(new ChatCompletionMessage("assistant", (String)response));
                } else {
                    List<ChatCompletionMessage> messages = body.getMessages();
                    ChatCompletionMessage message = messages.get(messages.size() - 1);
                    message.setContent(message.getContent() + response);
                }
                ++this.retryCounter;
                this.createNewEventSource(requestBody, listeners);
            }
            if (requestBody instanceof TextCompletionRequest) {
                listeners.onComplete(new StringBuilder((String)response));
            }
        }));
    }
}

