/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.completion;

import ee.carlrobert.openai.PropertiesLoader;
import ee.carlrobert.openai.client.OpenAIClient;
import ee.carlrobert.openai.client.completion.CompletionClient;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;

public abstract class OpenAICompletionClient
extends CompletionClient {
    private static final String BASE_URL = PropertiesLoader.getValue("openai.baseUrl");
    private final OpenAIClient client;

    public OpenAICompletionClient(OpenAIClient client, String path) {
        super(client, client.getHost() == null ? BASE_URL : client.getHost(), path);
        this.client = client;
    }

    @Override
    protected Map<String, String> getRequiredHeaders() {
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>(Map.of("Authorization", "Bearer " + this.client.getApiKey()));
        String organization = this.client.getOrganization();
        if (organization != null && !organization.isEmpty()) {
            headers.put("OpenAI-Organization", (CallSite)((Object)organization));
        }
        return headers;
    }
}

