/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.completion.chat;

import ee.carlrobert.openai.client.completion.CompletionModel;
import java.util.Arrays;

public enum ChatCompletionModel implements CompletionModel
{
    GPT_3_5("gpt-3.5-turbo", "ChatGPT(3.5) - Most capable model (Default)", 4096),
    GPT_3_5_16k("gpt-3.5-turbo-16k", "ChatGPT(3.5) - 16k - Same capabilities as 3.5 but with 4x the context", 16384),
    GPT_4("gpt-4", "ChatGPT(4.0) - Most recent model", 8192),
    GPT_4_32k("gpt-4-32k", "ChatGPT(4.0) - 32k - Same capabilities as 4.0 but with 4x the context", 32768);

    private final String code;
    private final String description;
    private final int maxTokens;

    private ChatCompletionModel(String code, String description, int maxTokens) {
        this.code = code;
        this.description = description;
        this.maxTokens = maxTokens;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getMaxTokens() {
        return this.maxTokens;
    }

    public static ChatCompletionModel findByCode(String code) {
        return Arrays.stream(ChatCompletionModel.values()).filter(item -> item.getCode().equals(code)).findFirst().orElseThrow();
    }
}

