/*
 * Decompiled with CFR 0.152.
 */
package ee.carlrobert.openai.client.embeddings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ee.carlrobert.openai.PropertiesLoader;
import ee.carlrobert.openai.client.Client;
import ee.carlrobert.openai.client.ClientCode;
import ee.carlrobert.openai.client.OpenAIClient;
import ee.carlrobert.openai.client.embeddings.EmbeddingData;
import ee.carlrobert.openai.client.embeddings.EmbeddingResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class EmbeddingsClient {
    private static final String BASE_URL = PropertiesLoader.getValue("openai.baseUrl");
    private final String baseUrl;
    private final Client client;

    public EmbeddingsClient(OpenAIClient client) {
        this.client = client;
        this.baseUrl = client.getHost() == null ? BASE_URL : client.getHost();
    }

    public ClientCode getClientCode() {
        return ClientCode.EMBEDDINGS;
    }

    public double[] getEmbedding(String input) {
        return this.getEmbeddings(List.of(input)).get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<double[]> getEmbeddings(List<String> texts) {
        try (Response response = this.client.getHttpClient().newCall(this.buildRequest(this.baseUrl + "/v1/embeddings", texts)).execute();){
            if (response.body() == null) return null;
            List<double[]> list = ((EmbeddingResponse)new ObjectMapper().readValue(response.body().string(), EmbeddingResponse.class)).getData().stream().map(EmbeddingData::getEmbedding).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to fetch embedding", e);
        }
    }

    private Request buildRequest(String url, List<String> texts) throws JsonProcessingException {
        return new Request.Builder().url(url).headers(Headers.of(Map.of("Authorization", "Bearer " + this.client.getApiKey()))).post(RequestBody.create((String)new ObjectMapper().writeValueAsString(Map.of("input", texts, "model", "text-embedding-ada-002")), (MediaType)MediaType.parse((String)"application/json"))).build();
    }
}

