/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.autohorize;

import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class ProxyAuthentication {
    private static final Authentication DUMMY = new Authentication();
    private static final ThreadLocal<Authentication> CURRENT = ThreadLocal.withInitial(ProxyAuthentication::getDummy);

    private static Authentication getDummy() {
        return DUMMY;
    }

    static void initState(HttpSession session) {
        CURRENT.set(session == null || session.getAttribute("X-D6-IDCode") == null ? DUMMY : new Authentication(session));
    }

    static void clearState() {
        CURRENT.remove();
    }

    public static String getUserIdCode() {
        return CURRENT.get().getUserIdCode();
    }

    public static String getMapsession() {
        return CURRENT.get().getMapsession();
    }

    public static String getUserName() {
        return CURRENT.get().getUserName();
    }

    public static boolean isAuthenticated() {
        return CURRENT.get().isAuthenticated();
    }

    private ProxyAuthentication() {
    }

    private static final class Authentication {
        private final String mapsession;
        private final String useridcode;
        private final String username;

        protected Authentication() {
            this.username = null;
            this.mapsession = null;
            this.useridcode = null;
        }

        protected Authentication(HttpSession session) {
            String user = null;
            String map = null;
            String name = null;
            user = (String)session.getAttribute("X-D6-IDCode");
            if (StringUtils.isBlank((CharSequence)user)) {
                user = null;
            } else {
                name = (String)session.getAttribute("X-D6-User-Name");
                map = (String)session.getAttribute("X-D6-Mapsession");
                if (StringUtils.isBlank((CharSequence)map)) {
                    map = null;
                }
            }
            this.useridcode = user;
            this.mapsession = map;
            this.username = name;
        }

        protected String getUserIdCode() {
            return this.useridcode;
        }

        protected String getMapsession() {
            return this.mapsession;
        }

        protected String getUserName() {
            return this.username;
        }

        protected boolean isAuthenticated() {
            return this.useridcode != null;
        }
    }
}

