/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.config;

import java.util.Locale;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
public class LocaleConfiguration {
    protected static final Integer COOKIE_MAX_AGE = 2592000;

    @Bean
    public LocaleResolver localeResolver(Environment env, @Value(value="${application.context.name}") String appName, @Value(value="${server.servlet.session.cookie.secure}") boolean sslCookie) {
        CookieLocaleResolver clr = new CookieLocaleResolver();
        clr.setDefaultLocale(Locale.forLanguageTag("et"));
        clr.setCookiePath("/" + appName);
        clr.setCookieName("EGTLANG");
        clr.setCookieMaxAge(COOKIE_MAX_AGE);
        clr.setCookieHttpOnly(true);
        clr.setCookieSecure(env.acceptsProfiles(Profiles.of((String[])new String[]{"prod"})) || sslCookie);
        return clr;
    }

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor lci = new LocaleChangeInterceptor();
        lci.setHttpMethods(new String[]{"GET"});
        lci.setParamName("language");
        return lci;
    }

    @Bean
    MappedInterceptor localeInterceptor() {
        return new MappedInterceptor(null, (HandlerInterceptor)this.localeChangeInterceptor());
    }
}

