/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.controller;

import ee.datel.dogis.admin.service.AuthorizeService;
import ee.datel.dogis.admin.service.DeployService;
import ee.datel.dogis.exception.HttpStatusException;
import ee.datel.dogis.exception.ManagedServerException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deploy"})
public class DeployController {
    private final Logger logger = LoggerFactory.getLogger(DeployController.class);
    private final AuthorizeService athorizer;
    private final DeployService srv;

    public DeployController(AuthorizeService athorizer, DeployService srv) {
        this.athorizer = athorizer;
        this.srv = srv;
    }

    @GetMapping(value={"/{appid}"}, produces={"application/json"})
    @ResponseBody
    public List<Object> sendConfiguration(@PathVariable(value="appid") String appid, HttpServletResponse response) throws HttpStatusException {
        this.athorizer.authorizeDeploy();
        this.logger.info("Sending application [{}] configuration", (Object)appid);
        try {
            return this.srv.send(appid);
        }
        catch (ManagedServerException ex) {
            throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
    }
}

