/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.controller;

import ee.datel.dogis.admin.autohorize.ProxyAuthentication;
import ee.datel.dogis.admin.model.DictionaryModel;
import ee.datel.dogis.admin.model.DictionaryRequestModel;
import ee.datel.dogis.admin.model.DictionaryTableModel;
import ee.datel.dogis.admin.model.Translated;
import ee.datel.dogis.admin.service.AuthorizeService;
import ee.datel.dogis.admin.service.DictionaryExpImpService;
import ee.datel.dogis.admin.service.DictionaryService;
import ee.datel.dogis.common.reader.dict.DictionaryEntry;
import ee.datel.dogis.exception.HttpStatusException;
import ee.datel.dogis.model.MessageModel;
import ee.datel.dogis.utils.CommonUtils;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dictionary"})
public class DictionaryController {
    private final Logger logger = LoggerFactory.getLogger(DictionaryController.class);
    private final AuthorizeService athorizer;
    private final DictionaryService srv;
    private final DictionaryExpImpService eximp;

    public DictionaryController(AuthorizeService athorizer, DictionaryService srv, DictionaryExpImpService eximp) {
        this.athorizer = athorizer;
        this.srv = srv;
        this.eximp = eximp;
    }

    @PostMapping(value={"/table"}, produces={"application/json"})
    public DictionaryTableModel getTabelPage(@RequestBody DictionaryRequestModel filter) {
        return this.eximp.getTabelPage(filter);
    }

    @PostMapping(value={"/translate/{languages}"}, produces={"application/json"})
    public List<DictionaryModel> translateDictionary(@RequestBody String[] keys, @PathVariable String languages) {
        return this.srv.translateDictionary(keys, CommonUtils.split((String)languages, (char)','));
    }

    @PostMapping(value={"/export"}, produces={"application/json"})
    public List<DictionaryModel> exportDictionary(@RequestBody DictionaryRequestModel filter) {
        return this.eximp.exportDictionary(filter);
    }

    @PostMapping(value={"/import"}, produces={"application/json"})
    public MessageModel importDictionary(@RequestBody List<DictionaryModel> data) {
        this.athorizer.athorizerDictionary();
        this.logger.info("{} {} is importing", (Object)ProxyAuthentication.getUserIdCode(), (Object)ProxyAuthentication.getUserName());
        this.eximp.importDictionary(data);
        return MessageModel.of((Object)CommonUtils.concatenate((CharSequence[])new CharSequence[]{"Imported ", Integer.toString(data.size()), " notions"}));
    }

    @PostMapping(value={"/import-book"}, produces={"application/json"})
    public MessageModel importDictionaryBook(@RequestBody List<DictionaryEntry> data) {
        this.athorizer.athorizerDictionary();
        this.logger.info("{} {} is importing", (Object)ProxyAuthentication.getUserIdCode(), (Object)ProxyAuthentication.getUserName());
        this.eximp.importDictionaryBook(data);
        return MessageModel.of((Object)CommonUtils.concatenate((CharSequence[])new CharSequence[]{"Imported ", Integer.toString(data.size()), " notions"}));
    }

    @PostMapping(value={"/{category}/{entity}/{telos}/{language}"}, produces={"application/json"})
    public List<DictionaryModel> getLabels(@Valid @NotBlank @PathVariable(value="category") String category, @Valid @NotBlank @PathVariable(value="entity") String entity, @Valid @NotBlank @PathVariable(value="telos") String telos, @Valid @NotBlank @PathVariable(value="language") String language, @Valid @NotNull @RequestBody String[] properties) throws HttpStatusException {
        if (properties.length == 0) {
            throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Property array is empty");
        }
        return this.srv.getLabels(category, entity, properties, telos, language);
    }

    @GetMapping(value={"/{category}/{entity}/{property}/{telos}"}, produces={"application/json"})
    public DictionaryModel getOne(@Valid @NotBlank @PathVariable(value="category") String category, @Valid @NotBlank @PathVariable(value="entity") String entity, @Valid @NotBlank @PathVariable(value="property") String property, @Valid @NotBlank @PathVariable(value="telos") String telos) {
        return this.srv.getTranslates(category, entity, property, telos);
    }

    @GetMapping(value={"/{category}/{entity}/{property}/{telos}/{language}"}, produces={"application/json"})
    public Translated translateOne(@Valid @NotBlank @PathVariable(value="category") String category, @Valid @NotBlank @PathVariable(value="entity") String entity, @Valid @NotBlank @PathVariable(value="property") String property, @Valid @NotBlank @PathVariable(value="telos") String telos, @Valid @NotBlank @PathVariable(value="language") String language) {
        return Translated.of(this.srv.translateOne(category, entity, property, telos, language));
    }

    @DeleteMapping(value={"/{category}/{entity}/{property}/{telos}"}, produces={"application/json"})
    public MessageModel deleteOne(@Valid @NotBlank @PathVariable(value="category") String category, @Valid @NotBlank @PathVariable(value="entity") String entity, @Valid @NotBlank @PathVariable(value="property") String property, @Valid @NotBlank @PathVariable(value="telos") String telos) {
        this.athorizer.athorizerDictionary();
        this.srv.deleteOne(category, entity, property, telos);
        return MessageModel.of((Object)"OK");
    }

    @PostMapping(produces={"application/json"})
    public MessageModel saveOne(@Valid @RequestBody DictionaryModel data) {
        this.athorizer.athorizerDictionary();
        this.srv.saveTranslate(data);
        return MessageModel.of((Object)"OK");
    }

    @PostMapping(value={"/category"}, produces={"application/json"})
    public List<String> getCategory() {
        return this.srv.getCategory();
    }

    @PostMapping(value={"/entity"}, produces={"application/json"})
    public List<String> getEntity(@RequestBody DictionaryRequestModel filter) {
        return this.srv.getEntity(filter.getCategory());
    }

    @PostMapping(value={"/property"}, produces={"application/json"})
    public List<String> getProperty(@RequestBody DictionaryRequestModel filter) {
        return this.srv.getProperty(filter.getCategory(), filter.getEntity());
    }

    @PostMapping(value={"/telos"}, produces={"application/json"})
    public List<String> getTelos(@RequestBody DictionaryRequestModel filter) {
        return this.srv.getTelos(filter.getCategory(), filter.getEntity(), filter.getProperty());
    }

    @GetMapping(value={"/languages"}, produces={"application/json"})
    public Object getLanguages() {
        return this.srv.getLanguages();
    }
}

