/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.controller;

import ee.datel.dogis.admin.service.DeployService;
import ee.datel.dogis.common.reader.ConfigurationManager;
import ee.datel.dogis.exception.HttpStatusException;
import ee.datel.dogis.utils.JsonParserService;
import ee.datel.dogis.utils.TempFilesUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FilesController {
    private final Logger logger = LoggerFactory.getLogger(FilesController.class);
    private final DeployService srv;
    private final ConfigurationManager confSrv;
    private final JsonParserService parser;
    private final TempFilesUtils temp;

    public FilesController(DeployService srv, ConfigurationManager confSrv, JsonParserService parser, TempFilesUtils temp) {
        this.srv = srv;
        this.confSrv = confSrv;
        this.parser = parser;
        this.temp = temp;
    }

    @GetMapping(value={"/application/{appid}"})
    public void getApplication(@PathVariable(value="appid") String appid, HttpServletResponse httpResponse) throws HttpStatusException {
        try {
            Path zip = this.srv.prepareDeploy(appid, false);
            this.sendFile(zip, ".zip", appid, httpResponse);
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
    }

    @GetMapping(value={"/layer/{layerid}"})
    public void getFatLayer(@PathVariable(value="layerid") String layerid, HttpServletResponse httpResponse) throws HttpStatusException {
        try {
            Map layer = this.confSrv.getFatLayer(layerid, null);
            Path json = this.temp.getTempFilePath("download-", new String[]{".json"});
            try (BufferedWriter wrt = Files.newBufferedWriter(json, new OpenOption[0]);){
                this.parser.getObjectMapper().writeValue((Writer)wrt, (Object)layer);
            }
            this.sendFile(json, ".json", layerid, httpResponse);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
    }

    private void sendFile(Path file, String extension, String appid, HttpServletResponse response) throws IOException {
        String filename;
        try {
            filename = URLEncoder.encode(appid, "UTF-8") + extension;
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new IOException(ex.getMessage());
        }
        if (filename.indexOf(37) >= 0) {
            response.setHeader("Content-Disposition", "attachment; filename*=utf-8''" + filename);
        } else {
            response.setHeader("Content-Disposition", "attachment; filename=" + filename);
        }
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream out = response.getOutputStream();){
            Files.copy(file, (OutputStream)out);
        }
    }
}

