/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.controller;

import ee.datel.dogis.utils.DogisUtils;
import java.util.Arrays;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class LanguageController {
    private final String redirect;
    private final String defaultLanguage;
    private final String[] languages;

    LanguageController(DogisUtils utils, @Value(value="${application.context.name}") String appname) {
        this.languages = Arrays.copyOf(utils.getLanguages(), utils.getLanguages().length);
        Arrays.sort(this.languages);
        this.defaultLanguage = utils.getDefaultLocale().getLanguage();
        this.redirect = "redirect: /" + appname + "/";
    }

    @GetMapping(value={"/language/{language}"})
    public String setLanguage(@PathVariable(value="language") String language, HttpSession session) {
        if (Arrays.binarySearch(this.languages, language) >= 0) {
            session.setAttribute("DGLanguage", (Object)language);
        } else {
            session.setAttribute("DGLanguage", (Object)this.defaultLanguage);
        }
        return this.redirect;
    }
}

