/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.model;

import ee.datel.dogis.common.reader.dict.DictionaryEntry;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotBlank;

public class DictionaryModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotBlank(message="Missing category")
    private @NotBlank(message="Missing category") String category;
    @NotBlank(message="Missing entity")
    private @NotBlank(message="Missing entity") String entity;
    @NotBlank(message="Missing property")
    private @NotBlank(message="Missing property") String property;
    @NotBlank(message="Missing telos")
    private @NotBlank(message="Missing telos") String telos;
    private Map<String, String> translate;

    public static DictionaryModel of(String category, String entity, String property, String telos) {
        DictionaryModel res = new DictionaryModel();
        res.category = category;
        res.entity = entity;
        res.property = property;
        res.telos = telos;
        return res;
    }

    public static DictionaryModel of(String category, String entity, String property, String telos, String language, String translation) {
        DictionaryModel res = DictionaryModel.of(category, entity, property, telos);
        res.translate = Collections.singletonMap(language, translation);
        return res;
    }

    public static DictionaryModel of(DictionaryEntry data) {
        DictionaryModel mod = DictionaryModel.of(data.getCategory(), data.getEntity(), data.getProperty(), data.getTelos());
        mod.translate = Collections.singletonMap(data.getLanguage(), data.getTranslate());
        return mod;
    }

    public String getCategory() {
        return this.category;
    }

    public String getEntity() {
        return this.entity;
    }

    public String getProperty() {
        return this.property;
    }

    public String getTelos() {
        return this.telos;
    }

    public Map<String, String> getTranslate() {
        if (this.translate == null) {
            this.translate = new HashMap<String, String>();
        }
        return this.translate;
    }

    public void setTranslate(Map<String, String> translate) {
        this.translate = translate;
    }
}

