/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.service;

import ee.datel.dogis.common.reader.ConfigurationFilter;
import ee.datel.dogis.exception.HttpStatusException;
import ee.datel.dogis.exception.ManagedException;
import ee.datel.dogis.exception.ManagedServerException;
import ee.datel.dogis.model.UnfilteredBookmark;
import ee.datel.dogis.utils.CommonUtils;
import ee.datel.dogis.utils.JsonParserService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationAsIsFilter
implements ConfigurationFilter {
    private static final String NOT_NEEDED_IN_THIS_APPLICATION = "Not needed in this application";
    private final JsonParserService parser;

    @Autowired
    public ConfigurationAsIsFilter(JsonParserService parser) {
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> filterConfiguration(String id, InputStream in, HttpSession session) throws ManagedException {
        Map map;
        InputStreamReader inreader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            Map conf;
            StringBuilder sb = CommonUtils.popBuffer();
            try {
                conf = this.parser.parseJson((Reader)inreader, sb);
            }
            finally {
                CommonUtils.push((StringBuilder)sb);
            }
            HashMap<String, Object> fatiz = new HashMap<String, Object>();
            this.seekForFats(conf, fatiz);
            conf.put("_fatLayer", fatiz);
            map = conf;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)inreader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LoggerFactory.getLogger(ConfigurationAsIsFilter.class).error(ex.getMessage(), (Throwable)ex);
                throw new ManagedServerException(ex.getMessage());
            }
        }
        ((Reader)inreader).close();
        return map;
    }

    private Map<String, Object> seekForFats(Map<String, Object> conf, Map<String, Object> fatiz) throws HttpStatusException {
        Map<String, Object> core = null;
        for (Map.Entry<String, Object> entry : conf.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof String) {
                if (StringUtils.isBlank((CharSequence)((String)value)) || !"fatLayerId".equals(entry.getKey())) continue;
                fatiz.put((String)value, "fatLayerId");
                continue;
            }
            if (value instanceof Map) {
                this.seekForFats((Map)value, fatiz);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.seekForFats((List)value, fatiz);
        }
        return core;
    }

    private void seekForFats(List<Object> list, Map<String, Object> fatiz) throws HttpStatusException {
        for (Object value : list) {
            if (value == null) continue;
            if (value instanceof Map) {
                this.seekForFats((Map)value, fatiz);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.seekForFats((List)value, fatiz);
        }
    }

    public Map<String, Object> filterBookmark(String bookmark, HttpSession session) {
        throw new IllegalStateException(NOT_NEEDED_IN_THIS_APPLICATION);
    }

    public Map<String, Object> filterBookmark(String bookmark) throws ManagedException {
        throw new IllegalStateException(NOT_NEEDED_IN_THIS_APPLICATION);
    }

    public UnfilteredBookmark unfilterBookmark(String bookmark, HttpSession session) throws ManagedException {
        throw new IllegalStateException(NOT_NEEDED_IN_THIS_APPLICATION);
    }
}

