/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.service;

import ee.datel.dogis.admin.service.EventRegistrarService;
import ee.datel.dogis.common.reader.ConfigurationManager;
import ee.datel.dogis.exception.HttpStatusException;
import ee.datel.dogis.exception.ManagedServerException;
import ee.datel.dogis.utils.CommonUtils;
import ee.datel.dogis.utils.DeployCrypterService;
import ee.datel.dogis.utils.DogisUtils;
import ee.datel.dogis.utils.TempFilesUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class DeployService {
    private final Logger logger = LoggerFactory.getLogger(DeployService.class);
    private final Map<String, String> zipper = Collections.singletonMap("create", "true");
    private final ConfigurationManager confSrv;
    private final DeployCrypterService cryper;
    private final DogisUtils utils;
    private final TempFilesUtils temp;
    private final String[] urls;
    private final EventRegistrarService eventRegistrar;

    @Autowired
    public DeployService(ConfigurationManager confSrv, DeployCrypterService cryper, DogisUtils utils, TempFilesUtils temp, @Value(value="${application.proxy.configuration.deploy.urls:}") String[] urls, EventRegistrarService eventRegistrar) {
        this.confSrv = confSrv;
        this.cryper = cryper;
        this.utils = utils;
        this.urls = urls;
        this.temp = temp;
        this.eventRegistrar = eventRegistrar;
        for (int i = 0; i < urls.length; ++i) {
            this.urls[i] = CommonUtils.concatenate((CharSequence[])new CharSequence[]{this.urls[i], this.urls[i].charAt(this.urls[i].length() - 1) == '/' ? "deploy/" : "/deploy/"});
        }
    }

    public List<Object> send(String appid) throws ManagedServerException, HttpStatusException {
        long crc32;
        Path zip;
        try {
            zip = this.prepareDeploy(appid, true);
        }
        catch (HttpStatusException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new ManagedServerException(ex.getMessage());
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            crc32 = DogisUtils.getCrc32((InputStream)in);
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new ManagedServerException("CRC32 read error");
        }
        String key = CommonUtils.concatenate((CharSequence[])new CharSequence[]{LocalDate.now(ZoneId.of("Z")).toString(), "#", Long.toString(crc32), "#", appid});
        HttpHeaders headers = new HttpHeaders();
        headers.set("X-D6-Deploy", this.cryper.encrypt(key));
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        ArrayList<Object> result = new ArrayList<Object>();
        for (String url : this.urls) {
            this.sendFile(zip, url, headers, result);
        }
        this.eventRegistrar.registerDeploy(appid, result);
        return result;
    }

    public Path prepareDeploy(String appid, boolean addFatz) throws IOException {
        Map fatz = null;
        if (addFatz) {
            Map app = this.confSrv.getApplicationConfiguration(appid, null);
            fatz = (Map)app.get("_fatLayer");
        }
        Path zipFile = this.temp.getTempFilePath("todeploy-", new String[]{".zip"});
        URI uri = URI.create("jar:" + zipFile.toUri().toString());
        try (FileSystem zip = FileSystems.newFileSystem(uri, this.zipper);){
            Path root = zip.getRootDirectories().iterator().next();
            Path dir = root.resolve("application");
            Files.createDirectory(dir, new FileAttribute[0]);
            this.confSrv.addApplication(appid, dir);
            if (fatz != null) {
                dir = root.resolve("layers");
                Files.createDirectory(dir, new FileAttribute[0]);
                if (!fatz.isEmpty()) {
                    this.confSrv.addLayers(fatz.keySet(), dir);
                }
            }
        }
        return zipFile;
    }

    protected void sendFile(Path zip, String url, HttpHeaders headers, List<Object> list) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        list.add(result);
        result.put("url", url);
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            InputStreamResource file = new InputStreamResource((InputStream)in);
            HttpEntity entity = new HttpEntity((Object)file, (MultiValueMap)headers);
            this.utils.getRestTemplate().exchange(url, HttpMethod.PATCH, entity, String.class, new Object[0]).getBody();
            result.put("result", "OK");
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            result.put("error", ex.getMessage());
        }
    }
}

