/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.admin.service;

import ee.datel.dogis.admin.model.DictionaryModel;
import ee.datel.dogis.utils.CommonUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface DictionaryService {
    public DictionaryModel getTranslates(String var1, String var2, String var3, String var4);

    public List<DictionaryModel> getLabels(String var1, String var2, String[] var3, String var4, String var5);

    public List<DictionaryModel> getLabels(String var1, String[] var2, String var3, String var4, String var5);

    public void saveNewOne(String var1, String var2, String var3, String var4, String var5);

    public String translateOne(String var1, String var2, String var3, String var4, String var5);

    public void deleteOne(String var1, String var2, String var3, String var4);

    public void saveTranslate(DictionaryModel var1);

    public List<String> getCategory();

    public List<String> getEntity(String var1);

    public List<String> getProperty(String var1, String var2);

    public List<String> getTelos(String var1, String var2, String var3);

    public Object getLanguages();

    default public List<DictionaryModel> translateDictionary(String[] keys, String[] languages) {
        List<DictionaryModel> data = Arrays.stream(keys).map(s -> CommonUtils.split((String)s, (char)'.')).map(a -> DictionaryModel.of(a[0], a[1], a[2], a[3])).collect(Collectors.toList());
        data.stream().forEach(en -> en.setTranslate(Translator.translateDictionaryItem(this.getTranslates(en.getCategory(), en.getEntity(), en.getProperty(), en.getTelos()), languages)));
        return data;
    }

    public static class Translator {
        private Translator() {
        }

        protected static Map<String, String> translateDictionaryItem(DictionaryModel model, String[] languages) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String lang : languages) {
                for (Map.Entry<String, String> ent : model.getTranslate().entrySet()) {
                    if (!lang.equals(ent.getKey())) continue;
                    map.put(lang, ent.getValue() == null ? "" : ent.getValue());
                    break;
                }
                if (map.containsKey(lang)) continue;
                map.put(lang, "");
            }
            return map;
        }
    }
}

