package ee.repl.shape;

import ee.repl.shape.controllers.AdminController;
import ee.repl.shape.interfaces.ContentModel;
import io.javalin.Javalin;
import io.javalin.http.Context;

import java.util.ArrayList;
import java.util.List;

public class Shape {
    public List<ContentModel> contentModels = new ArrayList<>();
    private final List<Route> routes = new ArrayList<>();

    public Shape() {
        this.initBuiltInRoutes();
    }

    public void addContentModel(ContentModel contentModel) {
        this.contentModels.add(contentModel);
    }

    private int port() {
        int port = 7000;

        if (System.getenv("PORT") != null) {
            port = Integer.parseInt(System.getenv("PORT"));
        }

        return port;
    }

    private void initBuiltInRoutes() {
        this.routes.add(Route.get("/admin", AdminController.class, "index"));
    }

    public void addRoute(Route route) {
        this.routes.add(route);
    }

    public void run() {
        var app = Javalin.create();

        for (var route : this.routes) {
            switch (route.method) {
                case "GET" -> app.get(route.path, ctx -> {
                    var controller = route.controller.getDeclaredConstructor().newInstance();
                    var method = route.controller.getMethod(route.action, Context.class);
                    method.invoke(controller, ctx);
                });

                case "POST" -> app.post(route.path, ctx -> {
                    var controller = route.controller.getDeclaredConstructor().newInstance();
                    var method = route.controller.getMethod(route.action, Context.class);
                    method.invoke(controller, ctx);
                });

                case "PUT" -> app.put(route.path, ctx -> {
                    var controller = route.controller.getDeclaredConstructor().newInstance();
                    var method = route.controller.getMethod(route.action, Context.class);
                    method.invoke(controller, ctx);
                });

                case "DELETE" -> app.delete(route.path, ctx -> {
                    var controller = route.controller.getDeclaredConstructor().newInstance();
                    var method = route.controller.getMethod(route.action, Context.class);
                    method.invoke(controller, ctx);
                });

                default -> throw new RuntimeException("Invalid method: " + route.method);
            }
        }

        app.start(this.port());
    }
}
