package ee.repl.shape.fields;

public class TextField extends BaseField {
    public String prefix;
    public String suffix;

    public TextField(String identifier) {
        this.setIdentifier(identifier);
        this.addInjectedCss("text");
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public String adminEditableHtml(String value) {
        return "<input type=\"text\" name=\"" + this.getIdentifier() + "\" value=\"" + value + "\" />";
    }

    @Override
    public String adminViewableHtml(String value) {
        return "<span>" + value + "</span>";
    }
}
