/*
 * Decompiled with CFR 0.152.
 */
package ee.repl.shape;

import ee.repl.shape.Route;
import ee.repl.shape.controllers.AdminController;
import ee.repl.shape.interfaces.ContentModel;
import io.javalin.Javalin;
import io.javalin.http.Context;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Shape {
    public List<ContentModel> contentModels = new ArrayList<ContentModel>();
    private final List<Route> routes = new ArrayList<Route>();

    public Shape() {
        this.initBuiltInRoutes();
    }

    public void addContentModel(ContentModel contentModel) {
        this.contentModels.add(contentModel);
    }

    private int port() {
        int port = 7000;
        if (System.getenv("PORT") != null) {
            port = Integer.parseInt(System.getenv("PORT"));
        }
        return port;
    }

    private void initBuiltInRoutes() {
        this.routes.add(Route.get("/admin", AdminController.class, "index"));
    }

    public void addRoute(Route route) {
        this.routes.add(route);
    }

    public void run() {
        Javalin app = Javalin.create();
        block12: for (Route route : this.routes) {
            switch (route.method) {
                case "GET": {
                    app.get(route.path, ctx -> {
                        Object controller = route.controller.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Method method = route.controller.getMethod(route.action, Context.class);
                        method.invoke(controller, ctx);
                    });
                    continue block12;
                }
                case "POST": {
                    app.post(route.path, ctx -> {
                        Object controller = route.controller.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Method method = route.controller.getMethod(route.action, Context.class);
                        method.invoke(controller, ctx);
                    });
                    continue block12;
                }
                case "PUT": {
                    app.put(route.path, ctx -> {
                        Object controller = route.controller.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Method method = route.controller.getMethod(route.action, Context.class);
                        method.invoke(controller, ctx);
                    });
                    continue block12;
                }
                case "DELETE": {
                    app.delete(route.path, ctx -> {
                        Object controller = route.controller.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Method method = route.controller.getMethod(route.action, Context.class);
                        method.invoke(controller, ctx);
                    });
                    continue block12;
                }
            }
            throw new RuntimeException("Invalid method: " + route.method);
        }
        app.start(this.port());
    }
}

