/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import ee.sk.mid.MidHashType;
import ee.sk.mid.exception.MidInternalErrorException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;

public class MidAuthentication
implements Serializable {
    private static final Long serialVersionUID = 1L;
    private String result;
    private String signedHashInBase64;
    private MidHashType hashType;
    private String signatureValueInBase64;
    private String algorithmName;
    private X509Certificate certificate;

    private MidAuthentication(MobileIdAuthenticationBuilder builder) {
        this.result = builder.result;
        this.signedHashInBase64 = builder.signedHashInBase64;
        this.hashType = builder.hashType;
        this.signatureValueInBase64 = builder.signatureValueInBase64;
        this.algorithmName = builder.algorithmName;
        this.certificate = builder.certificate;
        if (!Base64.isBase64((String)this.signatureValueInBase64)) {
            throw new MidInternalErrorException("Returned signature value is not a valid Base64 string.");
        }
    }

    public byte[] getSignatureValue() {
        return Base64.decodeBase64((String)this.signatureValueInBase64);
    }

    public String getResult() {
        return this.result;
    }

    public String getSignatureValueInBase64() {
        return this.signatureValueInBase64;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getSignedHashInBase64() {
        return this.signedHashInBase64;
    }

    public MidHashType getHashType() {
        return this.hashType;
    }

    public static MobileIdAuthenticationBuilder newBuilder() {
        return new MobileIdAuthenticationBuilder();
    }

    public static class MobileIdAuthenticationBuilder {
        private String result;
        private String signedHashInBase64;
        private MidHashType hashType;
        private String signatureValueInBase64;
        private String algorithmName;
        private X509Certificate certificate;

        private MobileIdAuthenticationBuilder() {
        }

        public MobileIdAuthenticationBuilder withResult(String result) {
            this.result = result;
            return this;
        }

        public MobileIdAuthenticationBuilder withSignedHashInBase64(String signedHashInBase64) {
            this.signedHashInBase64 = signedHashInBase64;
            return this;
        }

        public MobileIdAuthenticationBuilder withHashType(MidHashType hashType) {
            this.hashType = hashType;
            return this;
        }

        public MobileIdAuthenticationBuilder withSignatureValueInBase64(String signatureValueInBase64) {
            this.signatureValueInBase64 = signatureValueInBase64;
            return this;
        }

        public MobileIdAuthenticationBuilder withAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public MobileIdAuthenticationBuilder withCertificate(X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public MidAuthentication build() {
            return new MidAuthentication(this);
        }
    }
}

