/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import ee.sk.mid.MidHashToSign;
import ee.sk.mid.MidHashType;
import java.security.SecureRandom;

public class MidAuthenticationHashToSign
extends MidHashToSign {
    private static MidHashType DEFAULT_HASH_TYPE = MidHashType.SHA256;

    private MidAuthenticationHashToSign(MobileIdAuthenticationHashToSignBuilder builder) {
        super(builder);
    }

    public static MidAuthenticationHashToSign generateRandomHashOfDefaultType() {
        return MidAuthenticationHashToSign.generateRandomHashOfType(DEFAULT_HASH_TYPE);
    }

    public static MidAuthenticationHashToSign generateRandomHashOfType(MidHashType hashType) {
        return MidAuthenticationHashToSign.newBuilder().withHash(MidAuthenticationHashToSign.getRandomBytes(hashType.getLengthInBytes())).withHashType(hashType).build();
    }

    public static MobileIdAuthenticationHashToSignBuilder newBuilder() {
        return new MobileIdAuthenticationHashToSignBuilder();
    }

    private static byte[] getRandomBytes(int lengthInBytes) {
        byte[] randomBytes = new byte[lengthInBytes];
        new SecureRandom().nextBytes(randomBytes);
        return randomBytes;
    }

    public static class MobileIdAuthenticationHashToSignBuilder
    extends MidHashToSign.HashToSignBuilder {
        @Override
        public MobileIdAuthenticationHashToSignBuilder withHash(byte[] hash) {
            super.withHash(hash);
            return this;
        }

        @Override
        public MobileIdAuthenticationHashToSignBuilder withHashInBase64(String hashInBase64) {
            super.withHashInBase64(hashInBase64);
            return this;
        }

        @Override
        public MobileIdAuthenticationHashToSignBuilder withHashType(MidHashType hashType) {
            super.withHashType(hashType);
            return this;
        }

        @Override
        public MidAuthenticationHashToSign build() {
            this.validateFields();
            return new MidAuthenticationHashToSign(this);
        }
    }
}

