/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import ee.sk.mid.MidAuthentication;
import ee.sk.mid.MidCertificateParser;
import ee.sk.mid.MidHashToSign;
import ee.sk.mid.MidSignature;
import ee.sk.mid.MidTrustUtil;
import ee.sk.mid.exception.MidException;
import ee.sk.mid.exception.MidInternalErrorException;
import ee.sk.mid.exception.MidMissingOrInvalidParameterException;
import ee.sk.mid.exception.MidNotMidClientException;
import ee.sk.mid.rest.MidConnector;
import ee.sk.mid.rest.MidRestConnector;
import ee.sk.mid.rest.MidSessionStatusPoller;
import ee.sk.mid.rest.dao.MidSessionSignature;
import ee.sk.mid.rest.dao.MidSessionStatus;
import ee.sk.mid.rest.dao.response.MidCertificateChoiceResponse;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidClient {
    private static final Logger logger = LoggerFactory.getLogger(MidClient.class);
    private String relyingPartyUUID;
    private String relyingPartyName;
    private String hostUrl;
    private Configuration networkConnectionConfig;
    private Client configuredClient;
    private MidConnector connector;
    private MidSessionStatusPoller sessionStatusPoller;
    private SSLContext trustSslContext;
    private KeyStore trustStore;

    private MidClient(MobileIdClientBuilder builder) {
        this.relyingPartyUUID = builder.relyingPartyUUID;
        this.relyingPartyName = builder.relyingPartyName;
        this.hostUrl = builder.hostUrl;
        this.networkConnectionConfig = builder.networkConnectionConfig;
        this.configuredClient = builder.configuredClient;
        this.connector = builder.connector;
        this.trustSslContext = builder.trustSslContext;
        this.trustStore = builder.trustStore;
        this.sessionStatusPoller = MidSessionStatusPoller.newBuilder().withConnector(this.getMobileIdConnector()).withPollingSleepTimeoutSeconds(builder.pollingSleepTimeoutSeconds).withLongPollingTimeoutSeconds(builder.longPollingTimeoutSeconds).build();
    }

    public MidConnector getMobileIdConnector() {
        if (null == this.connector) {
            this.connector = MidRestConnector.newBuilder().withEndpointUrl(this.hostUrl).withConfiguredClient(this.configuredClient).withClientConfig(this.networkConnectionConfig).withRelyingPartyUUID(this.relyingPartyUUID).withRelyingPartyName(this.relyingPartyName).withSslContext(this.getTrustSslContext()).build();
        }
        return this.connector;
    }

    public MidSessionStatusPoller getSessionStatusPoller() {
        return this.sessionStatusPoller;
    }

    public String getRelyingPartyUUID() {
        return this.relyingPartyUUID;
    }

    public String getRelyingPartyName() {
        return this.relyingPartyName;
    }

    public SSLContext getTrustSslContext() {
        return this.trustSslContext != null ? this.trustSslContext : MidTrustUtil.createSslContext(this.trustStore);
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public X509Certificate createMobileIdCertificate(MidCertificateChoiceResponse certificateChoiceResponse) {
        this.validateCertificateResult(certificateChoiceResponse.getResult());
        this.validateCertificateResponse(certificateChoiceResponse);
        return MidCertificateParser.parseX509Certificate(certificateChoiceResponse.getCert());
    }

    public MidSignature createMobileIdSignature(MidSessionStatus sessionStatus) {
        this.validateResponse(sessionStatus);
        MidSessionSignature sessionSignature = sessionStatus.getSignature();
        return MidSignature.newBuilder().withValueInBase64(sessionSignature.getValue()).withAlgorithmName(sessionSignature.getAlgorithm()).build();
    }

    public MidAuthentication createMobileIdAuthentication(MidSessionStatus sessionStatus, MidHashToSign hashSigned) {
        this.validateResponse(sessionStatus);
        MidSessionSignature sessionSignature = sessionStatus.getSignature();
        X509Certificate certificate = MidCertificateParser.parseX509Certificate(sessionStatus.getCert());
        return MidAuthentication.newBuilder().withResult(sessionStatus.getResult()).withSignatureValueInBase64(sessionSignature.getValue()).withAlgorithmName(sessionSignature.getAlgorithm()).withCertificate(certificate).withSignedHashInBase64(hashSigned.getHashInBase64()).withHashType(hashSigned.getHashType()).build();
    }

    private void validateCertificateResult(String result) throws MidException {
        if ("NOT_FOUND".equalsIgnoreCase(result) || "NOT_ACTIVE".equalsIgnoreCase(result)) {
            throw new MidNotMidClientException();
        }
        if (!"OK".equalsIgnoreCase(result)) {
            logger.error("Session status end result is '" + result + "'");
            throw new MidInternalErrorException("Session status end result is '" + result + "'");
        }
    }

    private void validateCertificateResponse(MidCertificateChoiceResponse certificateChoiceResponse) {
        if (certificateChoiceResponse.getCert() == null || StringUtils.isBlank((CharSequence)certificateChoiceResponse.getCert())) {
            logger.error("Certificate was not present in the session status response");
            throw new MidInternalErrorException("Certificate was not present in the session status response");
        }
    }

    private void validateResponse(MidSessionStatus sessionStatus) {
        if (sessionStatus.getSignature() == null || StringUtils.isBlank((CharSequence)sessionStatus.getSignature().getValue())) {
            logger.error("Signature was not present in the response");
            throw new MidInternalErrorException("Signature was not present in the response");
        }
    }

    public static MobileIdClientBuilder newBuilder() {
        return new MobileIdClientBuilder();
    }

    public static class MobileIdClientBuilder {
        private String relyingPartyUUID;
        private String relyingPartyName;
        private String hostUrl;
        private Configuration networkConnectionConfig;
        private Client configuredClient;
        private int pollingSleepTimeoutSeconds;
        private int longPollingTimeoutSeconds;
        private MidConnector connector;
        private SSLContext trustSslContext;
        private KeyStore trustStore;

        private MobileIdClientBuilder() {
        }

        public MobileIdClientBuilder withRelyingPartyUUID(String relyingPartyUUID) {
            this.relyingPartyUUID = relyingPartyUUID;
            return this;
        }

        public MobileIdClientBuilder withRelyingPartyName(String relyingPartyName) {
            this.relyingPartyName = relyingPartyName;
            return this;
        }

        public MobileIdClientBuilder withHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public MobileIdClientBuilder withNetworkConnectionConfig(Configuration networkConnectionConfig) {
            this.networkConnectionConfig = networkConnectionConfig;
            return this;
        }

        public MobileIdClientBuilder withConfiguredClient(Client configuredClient) {
            this.configuredClient = configuredClient;
            return this;
        }

        public MobileIdClientBuilder withPollingSleepTimeoutSeconds(int pollingSleepTimeoutSeconds) {
            this.pollingSleepTimeoutSeconds = pollingSleepTimeoutSeconds;
            return this;
        }

        public MobileIdClientBuilder withLongPollingTimeoutSeconds(int longPollingTimeoutSeconds) {
            this.longPollingTimeoutSeconds = longPollingTimeoutSeconds;
            return this;
        }

        public MobileIdClientBuilder withMobileIdConnector(MidConnector mobileIdConnector) {
            this.connector = mobileIdConnector;
            return this;
        }

        @Deprecated
        public MobileIdClientBuilder withSslContext(SSLContext sslContext) {
            return this.withTrustSslContext(sslContext);
        }

        public MobileIdClientBuilder withTrustSslContext(SSLContext trustSslContext) {
            if (this.trustSslContext != null) {
                throw new MidMissingOrInvalidParameterException("You can call only one of withTrustStore(), withTrustedCertificates() or withTrustSslContext()");
            }
            this.trustSslContext = trustSslContext;
            return this;
        }

        @Deprecated
        public MobileIdClientBuilder withSslCertificates(String ... trustedCertificate) {
            return this.withTrustedCertificates(trustedCertificate);
        }

        public MobileIdClientBuilder withTrustedCertificates(String ... trustedCertificate) {
            return this.withTrustStore(MidTrustUtil.createTrustStore(Arrays.asList(trustedCertificate)));
        }

        @Deprecated
        public MobileIdClientBuilder withSslKeyStore(KeyStore trustStore) {
            return this.withTrustStore(trustStore);
        }

        public MobileIdClientBuilder withTrustStore(KeyStore trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public MidClient build() {
            this.validateFields();
            return new MidClient(this);
        }

        private void validateFields() {
            if (this.pollingSleepTimeoutSeconds < 0) {
                throw new MidMissingOrInvalidParameterException("pollingSleepTimeoutSeconds must be non-negative number");
            }
            if (this.longPollingTimeoutSeconds < 0) {
                throw new MidMissingOrInvalidParameterException("longPollingTimeoutSeconds must be non-negative number");
            }
            if (this.trustSslContext == null && this.trustStore == null || this.trustSslContext != null && this.trustStore != null) {
                throw new MidMissingOrInvalidParameterException("Provide certificates of servers that are trusted by calling exactly one of 'withTrustSslContext()', 'withTrustStore()' or 'withTrustedCertificates()'");
            }
        }
    }
}

