/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import ee.sk.mid.MidHashType;
import ee.sk.mid.MidVerificationCodeCalculator;
import ee.sk.mid.exception.MidMissingOrInvalidParameterException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class MidHashToSign
implements Serializable {
    private static final Long serialVersionUID = 1L;
    protected byte[] hash;
    protected MidHashType hashType;

    protected MidHashToSign(HashToSignBuilder builder) {
        this.hashType = builder.hashType;
        this.hash = builder.dataToHash != null ? builder.hashType.calculateDigest(builder.dataToHash) : (byte[])builder.hash.clone();
    }

    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    public String getHashInBase64() {
        return Base64.encodeBase64String((byte[])this.hash);
    }

    public MidHashType getHashType() {
        return this.hashType;
    }

    public String calculateVerificationCode() {
        return MidVerificationCodeCalculator.calculateMobileIdVerificationCode(this.hash);
    }

    public static HashToSignBuilder newBuilder() {
        return new HashToSignBuilder();
    }

    public static class HashToSignBuilder {
        protected byte[] hash;
        protected MidHashType hashType;
        private byte[] dataToHash;

        public HashToSignBuilder withDataToHash(byte[] dataToSign) {
            if (dataToSign == null || dataToSign.length == 0) {
                throw new MidMissingOrInvalidParameterException("Cannot pass empty dataToHash value");
            }
            this.dataToHash = Arrays.copyOf(dataToSign, dataToSign.length);
            return this;
        }

        public HashToSignBuilder withHash(byte[] hash) {
            if (hash == null || hash.length == 0) {
                throw new MidMissingOrInvalidParameterException("Cannot pass empty hash value");
            }
            this.hash = (byte[])hash.clone();
            return this;
        }

        public HashToSignBuilder withHashInBase64(String hashInBase64) {
            if (!Base64.isBase64((String)hashInBase64)) {
                throw new MidMissingOrInvalidParameterException("hash is not valid Base64 encoded string");
            }
            this.hash = Base64.decodeBase64((String)hashInBase64);
            return this;
        }

        public HashToSignBuilder withHashType(MidHashType hashType) {
            this.hashType = hashType;
            return this;
        }

        public MidHashToSign build() {
            this.validateFields();
            return new MidHashToSign(this);
        }

        void validateFields() {
            if (this.hashType == null) {
                throw new MidMissingOrInvalidParameterException("Missing hash type");
            }
            if (this.hash == null && this.dataToHash == null) {
                throw new MidMissingOrInvalidParameterException("Missing hash or dataToHash");
            }
            if (this.hash != null && this.dataToHash != null) {
                throw new IllegalArgumentException("You can only pass in either hash or dataToHash but not both");
            }
        }
    }
}

